/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.token;

import cn.dolphin.core.date.DateUtil;
import cn.dolphin.core.util.MD5Util;
import java.io.Serializable;
import java.util.Date;
import java.util.UUID;

public abstract class Token
implements Serializable {
    private static final long serialVersionUID = -3871114844781666085L;
    private static final String KEY = "69391a3ffeb649cb92acfffc3b2de8da";
    private long issueTime;
    private long expires;
    private String issuer;
    private String signature;

    protected static String getToken() {
        return MD5Util.encryptPasswordTwice(UUID.randomUUID() + KEY + DateUtil.getMillis(new Date()));
    }

    protected static String getToken(String appkey) {
        return MD5Util.encryptPasswordTwice(UUID.randomUUID() + appkey + DateUtil.getMillis(new Date()));
    }

    protected static String getUniqueID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public long getIssueTime() {
        return this.issueTime;
    }

    public long getExpires() {
        return this.expires;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setIssueTime(long issueTime) {
        this.issueTime = issueTime;
    }

    public void setExpires(long expires) {
        this.expires = expires;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token other = (Token)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIssueTime() != other.getIssueTime()) {
            return false;
        }
        if (this.getExpires() != other.getExpires()) {
            return false;
        }
        String this$issuer = this.getIssuer();
        String other$issuer = other.getIssuer();
        if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Token;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $issueTime = this.getIssueTime();
        result = result * 59 + (int)($issueTime >>> 32 ^ $issueTime);
        long $expires = this.getExpires();
        result = result * 59 + (int)($expires >>> 32 ^ $expires);
        String $issuer = this.getIssuer();
        result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        return result;
    }

    public String toString() {
        return "Token(issueTime=" + this.getIssueTime() + ", expires=" + this.getExpires() + ", issuer=" + this.getIssuer() + ", signature=" + this.getSignature() + ")";
    }
}

