/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.thread;

import cn.dolphin.core.thread.GlobalThreadPool;
import cn.dolphin.core.thread.NamedThreadFactory;
import cn.dolphin.core.util.EmptyUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtil {
    private static final Logger logger = LoggerFactory.getLogger(ThreadUtil.class);
    public static ThreadPoolExecutor executor = null;
    private static int corePoolSize = 1;
    private static int maximumPoolSize = 3;
    private static long keepAliveTime = 1000L;
    private static TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private static BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(1);
    private static ThreadFactory threadFactory = Thread::new;
    public ThreadPoolExecutor newExecutor;

    public ThreadUtil(int core, int maximum, int keep, TimeUnit unit) {
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(1);
        ThreadFactory factory = Thread::new;
        this.newExecutor = new ThreadPoolExecutor(core, maximum, (long)keep, unit, queue, factory);
    }

    public static void init() {
        executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, timeUnit, workQueue, threadFactory);
    }

    public static void init(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit timeUnit) {
        ThreadUtil.corePoolSize = corePoolSize;
        ThreadUtil.maximumPoolSize = maximumPoolSize;
        ThreadUtil.keepAliveTime = keepAliveTime;
        ThreadUtil.timeUnit = timeUnit;
        ThreadUtil.init();
    }

    public static ExecutorService newExecutor(int threadSize) {
        return new ThreadPoolExecutor(threadSize, threadSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public static ExecutorService newExecutor() {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    public static ExecutorService newSingleExecutor() {
        return Executors.newSingleThreadExecutor();
    }

    public static ThreadPoolExecutor newExecutor(int corePoolSize, int maximumPoolSize) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public static ThreadPoolExecutor newExecutorByBlockingCoefficient(float blockingCoefficient) {
        if (blockingCoefficient >= 1.0f || blockingCoefficient < 0.0f) {
            throw new IllegalArgumentException("[blockingCoefficient] must between 0 and 1, or equals 0.");
        }
        int poolSize = (int)((float)Runtime.getRuntime().availableProcessors() / (1.0f - blockingCoefficient));
        return new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public static void execute(Runnable runnable) {
        GlobalThreadPool.execute(runnable);
    }

    public static Runnable excAsync(final Runnable runnable, boolean isDeamon) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                runnable.run();
            }
        };
        thread.setDaemon(isDeamon);
        thread.start();
        return runnable;
    }

    public static <T> Future<T> execAsync(Callable<T> task) {
        return GlobalThreadPool.submit(task);
    }

    public static Future<?> execAsync(Runnable runnable) {
        return GlobalThreadPool.submit(runnable);
    }

    public static <T> CompletionService<T> newCompletionService() {
        return new ExecutorCompletionService(GlobalThreadPool.getExecutor());
    }

    public static <T> CompletionService<T> newCompletionService(ExecutorService executor) {
        return new ExecutorCompletionService(executor);
    }

    public static CountDownLatch newCountDownLatch(int threadCount) {
        return new CountDownLatch(threadCount);
    }

    public static Thread newThread(Runnable runnable, String name) {
        Thread t = new Thread(ThreadUtil.currentThreadGroup(), runnable, name);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }

    public static boolean sleep(Number timeout, TimeUnit timeUnit) {
        try {
            timeUnit.sleep(timeout.longValue());
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public static boolean sleep(Number millis) {
        if (millis == null) {
            return true;
        }
        try {
            Thread.sleep(millis.longValue());
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public static boolean safeSleep(Number millis) {
        long before;
        long after;
        long millisLong = millis.longValue();
        for (long done = 0L; done < millisLong; done += after - before) {
            before = System.currentTimeMillis();
            if (!ThreadUtil.sleep(millisLong - done)) {
                return false;
            }
            after = System.currentTimeMillis();
        }
        return true;
    }

    public static StackTraceElement[] getStackTrace() {
        return Thread.currentThread().getStackTrace();
    }

    public static StackTraceElement getStackTraceElement(int i) {
        StackTraceElement[] stackTrace = ThreadUtil.getStackTrace();
        if (i < 0) {
            i += stackTrace.length;
        }
        return stackTrace[i];
    }

    public static <T> ThreadLocal<T> createThreadLocal(boolean isInheritable) {
        if (isInheritable) {
            return new InheritableThreadLocal();
        }
        return new ThreadLocal();
    }

    public static void interupt(Thread thread, boolean isJoin) {
        if (null != thread && !thread.isInterrupted()) {
            thread.interrupt();
            if (isJoin) {
                ThreadUtil.waitForDie(thread);
            }
        }
    }

    public static void waitForDie(Thread thread) {
        boolean dead = false;
        do {
            try {
                thread.join();
                dead = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!dead);
    }

    public static Thread[] getThreads() {
        return ThreadUtil.getThreads(Thread.currentThread().getThreadGroup().getParent());
    }

    public static Thread[] getThreads(ThreadGroup group) {
        Thread[] slackList = new Thread[group.activeCount() * 2];
        int actualSize = group.enumerate(slackList);
        Thread[] result = new Thread[actualSize];
        System.arraycopy(slackList, 0, result, 0, actualSize);
        return result;
    }

    public static Thread getMainThread() {
        for (Thread thread : ThreadUtil.getThreads()) {
            if (thread.getId() != 1L) continue;
            return thread;
        }
        return null;
    }

    public static ThreadGroup currentThreadGroup() {
        SecurityManager s = System.getSecurityManager();
        return null != s ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
    }

    public static ThreadFactory newNamedThreadFactory(String prefix, boolean isDeamon) {
        return new NamedThreadFactory(prefix, isDeamon);
    }

    public static ThreadFactory newNamedThreadFactory(String prefix, ThreadGroup threadGroup, boolean isDeamon) {
        return new NamedThreadFactory(prefix, threadGroup, isDeamon);
    }

    public static ThreadFactory newNamedThreadFactory(String prefix, ThreadGroup threadGroup, boolean isDeamon, Thread.UncaughtExceptionHandler handler) {
        return new NamedThreadFactory(prefix, threadGroup, isDeamon, handler);
    }

    public static ThreadPoolExecutor getExecutor() {
        if (EmptyUtil.isNull(executor)) {
            ThreadUtil.init();
        }
        return executor;
    }

    public static void sleep2(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public static void shutdownAndAwaitTermination(ExecutorService pool) {
        if (pool != null && !pool.isShutdown()) {
            pool.shutdown();
            try {
                if (!pool.awaitTermination(120L, TimeUnit.SECONDS)) {
                    pool.shutdownNow();
                    if (!pool.awaitTermination(120L, TimeUnit.SECONDS)) {
                        logger.info("Pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                pool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void printException(Runnable r, Throwable t) {
        if (t == null && r instanceof Future) {
            try {
                Future future = (Future)((Object)r);
                if (future.isDone()) {
                    future.get();
                }
            }
            catch (CancellationException ce) {
                t = ce;
            }
            catch (ExecutionException ee) {
                t = ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (t != null) {
            logger.error(t.getMessage(), t);
        }
    }

    public static int getCorePoolSize() {
        return corePoolSize;
    }

    public static void setCorePoolSize(int corePoolSize) {
        ThreadUtil.corePoolSize = corePoolSize;
    }

    public static int getMaximumPoolSize() {
        return maximumPoolSize;
    }

    public static void setMaximumPoolSize(int maximumPoolSize) {
        ThreadUtil.maximumPoolSize = maximumPoolSize;
    }

    public static long getKeepAliveTime() {
        return keepAliveTime;
    }

    public static void setKeepAliveTime(int keepAliveTime) {
        ThreadUtil.keepAliveTime = keepAliveTime;
    }

    public static TimeUnit getTimeUnit() {
        return timeUnit;
    }

    public static void setTimeUnit(TimeUnit unit) {
        timeUnit = unit;
    }

    public static BlockingQueue<Runnable> getWorkQueue() {
        return workQueue;
    }

    public static void setWorkQueue(BlockingQueue<Runnable> workQueue) {
        ThreadUtil.workQueue = workQueue;
    }

    public static ThreadFactory getThreadFactory() {
        return threadFactory;
    }

    public static void setThreadFactory(ThreadFactory threadFactory) {
        ThreadUtil.threadFactory = threadFactory;
    }
}

