/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.thread;

import cn.dolphin.core.exception.UtilsRuntimeException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class GlobalThreadPool {
    private static ExecutorService executor;

    private GlobalThreadPool() {
    }

    public static synchronized void init() {
        if (null != executor) {
            executor.shutdownNow();
        }
        executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    public static synchronized void shutdown(boolean isNow) {
        if (null != executor) {
            if (isNow) {
                executor.shutdownNow();
            } else {
                executor.shutdown();
            }
        }
    }

    public static ExecutorService getExecutor() {
        return executor;
    }

    public static void execute(Runnable runnable) {
        try {
            executor.execute(runnable);
        }
        catch (Exception e) {
            throw new UtilsRuntimeException("Exception when running task!", e);
        }
    }

    public static <T> Future<T> submit(Callable<T> task) {
        return executor.submit(task);
    }

    public static Future<?> submit(Runnable runnable) {
        return executor.submit(runnable);
    }

    static {
        GlobalThreadPool.init();
    }
}

