/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.spring;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.interceptor.AsyncExecutionInterceptor;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.transaction.interceptor.TransactionInterceptor;

public class SpringProxyUtil {
    public static <T> T getRealTarget(Object proxy) {
        while (AopUtils.isAopProxy((Object)proxy)) {
            ProxyFactory proxyFactory = null;
            if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
                proxyFactory = SpringProxyUtil.findJdkDynamicProxyFactory(proxy);
            }
            if (AopUtils.isCglibProxy((Object)proxy)) {
                proxyFactory = SpringProxyUtil.findCglibProxyFactory(proxy);
            }
            ConfigurablePropertyAccessor accessor = PropertyAccessorFactory.forDirectFieldAccess((Object)proxyFactory);
            TargetSource targetSource = (TargetSource)accessor.getPropertyValue("targetSource");
            try {
                proxy = targetSource.getTarget();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (T)proxy;
    }

    public static boolean isMultipleProxy(Object proxy) {
        try {
            ProxyFactory proxyFactory = null;
            if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
                proxyFactory = SpringProxyUtil.findJdkDynamicProxyFactory(proxy);
            }
            if (AopUtils.isCglibProxy((Object)proxy)) {
                proxyFactory = SpringProxyUtil.findCglibProxyFactory(proxy);
            }
            ConfigurablePropertyAccessor accessor = PropertyAccessorFactory.forDirectFieldAccess((Object)proxyFactory);
            TargetSource targetSource = (TargetSource)accessor.getPropertyValue("targetSource");
            return AopUtils.isAopProxy((Object)targetSource.getTarget());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("proxy args maybe not proxy with cglib or jdk dynamic proxy. this method not support", e);
        }
    }

    public static ProxyFactory findJdkDynamicProxyFactory(Object proxy) {
        InvocationHandler h = Proxy.getInvocationHandler(proxy);
        ConfigurablePropertyAccessor accessor = PropertyAccessorFactory.forDirectFieldAccess((Object)h);
        return (ProxyFactory)accessor.getPropertyValue("advised");
    }

    public static ProxyFactory findCglibProxyFactory(Object proxy) {
        ConfigurablePropertyAccessor accessor = PropertyAccessorFactory.forDirectFieldAccess((Object)proxy);
        Object cglib$CALLBACK_0 = accessor.getPropertyValue("CGLIB$CALLBACK_0");
        accessor = PropertyAccessorFactory.forDirectFieldAccess((Object)cglib$CALLBACK_0);
        return (ProxyFactory)accessor.getPropertyValue("advised");
    }

    public static boolean isTransactional(Object proxy) {
        return SpringProxyUtil.hasAdvice(proxy, TransactionInterceptor.class);
    }

    public static void removeTransactional(Object proxy) {
        SpringProxyUtil.removeAdvisor(proxy, TransactionInterceptor.class);
    }

    public static boolean isAsync(Object proxy) {
        return SpringProxyUtil.hasAdvice(proxy, AsyncExecutionInterceptor.class);
    }

    public static void removeAsync(Object proxy) {
        SpringProxyUtil.removeAdvisor(proxy, AsyncExecutionInterceptor.class);
    }

    private static void removeAdvisor(Object proxy, Class<? extends Advice> adviceClass) {
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return;
        }
        ProxyFactory proxyFactory = null;
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            proxyFactory = SpringProxyUtil.findJdkDynamicProxyFactory(proxy);
        }
        if (AopUtils.isCglibProxy((Object)proxy)) {
            proxyFactory = SpringProxyUtil.findCglibProxyFactory(proxy);
        }
        if (proxyFactory == null) {
            return;
        }
        Advisor[] advisors = proxyFactory.getAdvisors();
        if (advisors.length == 0) {
            return;
        }
        for (Advisor advisor : advisors) {
            if (!adviceClass.isAssignableFrom(advisor.getAdvice().getClass())) continue;
            proxyFactory.removeAdvisor(advisor);
            break;
        }
    }

    private static boolean hasAdvice(Object proxy, Class<? extends Advice> adviceClass) {
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return false;
        }
        ProxyFactory proxyFactory = null;
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            proxyFactory = SpringProxyUtil.findJdkDynamicProxyFactory(proxy);
        }
        if (AopUtils.isCglibProxy((Object)proxy)) {
            proxyFactory = SpringProxyUtil.findCglibProxyFactory(proxy);
        }
        if (proxyFactory == null) {
            return false;
        }
        Advisor[] advisors = proxyFactory.getAdvisors();
        if (advisors.length == 0) {
            return false;
        }
        for (Advisor advisor : advisors) {
            if (!adviceClass.isAssignableFrom(advisor.getAdvice().getClass())) continue;
            return true;
        }
        return false;
    }
}

