/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.spring;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.web.context.support.XmlWebApplicationContext;

@Component
public class SpringContextUtil
implements ApplicationContextAware,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(SpringContextUtil.class);
    private static final Map<String, Object> CACHE_MAP = new HashMap<String, Object>();
    private static ApplicationContext applicationContext;
    private static volatile SpringContextUtil instance;

    private SpringContextUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpringContextUtil getInstance() {
        try {
            if (instance != null) return instance;
            Thread.sleep(300L);
            Class<SpringContextUtil> clazz = SpringContextUtil.class;
            synchronized (SpringContextUtil.class) {
                if (instance != null) return instance;
                instance = new SpringContextUtil();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return instance;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringContextUtil.applicationContext = applicationContext;
        log.info("@Springboot Starting [SpringContext\u5904\u7406\u673a\u5236] ");
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)SpringContextUtil.getApplicationContext().getBean(clazz);
    }

    public static <T> T getBean(String name) {
        return (T)SpringContextUtil.getApplicationContext().getBean(name);
    }

    public static <T> T getBean(String name, Class<T> requiredType) {
        return (T)SpringContextUtil.getApplicationContext().getBean(name, requiredType);
    }

    public static <T> T getBeanByClass(Class<T> clazz) {
        try {
            return (T)SpringContextUtil.getTarget(SpringContextUtil.getApplicationContext().getBean(clazz));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5bf9\u8c61\u9519\u8bef:", (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> getBeansByClass(Class<T> clazz) {
        String[] names = SpringContextUtil.getApplicationContext().getBeanNamesForType(clazz);
        ArrayList<T> result = new ArrayList<T>();
        for (String name : names) {
            result.add(SpringContextUtil.getBean(name));
        }
        return result;
    }

    public static <T> T getBeanByClassForApi(Class<T> clazz) {
        String[] names = SpringContextUtil.getApplicationContext().getBeanNamesForType(clazz);
        T resultBean = null;
        String serviceName = clazz.getName();
        if (names.length > 1) {
            for (String name : names) {
                if (name.equals(serviceName)) continue;
                resultBean = SpringContextUtil.getBean(name);
                break;
            }
        }
        if (resultBean == null) {
            resultBean = SpringContextUtil.getBean(serviceName);
        }
        return resultBean;
    }

    public static <T> T getBeanByClass(Class<T> clazz, String[] actualTypeArguments) {
        StringBuilder sBuilder = new StringBuilder();
        String cacheKey = null;
        for (String actualTypeArgument : actualTypeArguments) {
            sBuilder.append("_" + actualTypeArgument);
        }
        cacheKey = clazz.getName() + sBuilder.toString();
        if (CACHE_MAP.containsKey(cacheKey)) {
            return (T)CACHE_MAP.get(cacheKey);
        }
        String[] candidateNames = applicationContext.getBeanNamesForType(clazz);
        Object object = null;
        Type[] types = null;
        for (String candidateName : candidateNames) {
            object = SpringContextUtil.getBean(candidateName);
            types = object.getClass().getName().contains("EnhancerBySpringCGLIB") ? ((ParameterizedType)object.getClass().getSuperclass().getGenericSuperclass()).getActualTypeArguments() : ((ParameterizedType)object.getClass().getGenericSuperclass()).getActualTypeArguments();
            boolean isThisObj = true;
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                if (actualTypeArguments[i].equals(types[i].getTypeName())) continue;
                isThisObj = false;
                break;
            }
            if (!isThisObj) continue;
            CACHE_MAP.put(cacheKey, object);
            return (T)object;
        }
        return null;
    }

    public static boolean containsBean(String name) {
        return SpringContextUtil.getApplicationContext().containsBean(name);
    }

    public static boolean isSingleton(String name) {
        return SpringContextUtil.getApplicationContext().isSingleton(name);
    }

    public static Class<? extends Object> getType(String name) {
        return SpringContextUtil.getApplicationContext().getType(name);
    }

    public static String[] getAliases(String beanId) {
        return SpringContextUtil.getApplicationContext().getAliases(beanId);
    }

    public static Environment getEnvironment() {
        return SpringContextUtil.getApplicationContext().getEnvironment();
    }

    public static Map<String, BeanDefinition> getApplicationBeanDefinitions() {
        String[] names;
        HashMap<String, BeanDefinition> map = new HashMap<String, BeanDefinition>();
        XmlWebApplicationContext context = (XmlWebApplicationContext)applicationContext;
        ConfigurableListableBeanFactory factory = context.getBeanFactory();
        for (String name : names = factory.getBeanDefinitionNames()) {
            map.put(name, factory.getBeanDefinition(name));
        }
        return map;
    }

    public void destroy() throws Exception {
        SpringContextUtil.cleanHolder();
    }

    public static void cleanHolder() {
        applicationContext = null;
    }

    private static void assertContextInjected() {
        Validate.validState((applicationContext != null ? 1 : 0) != 0, (String)"applicaitonContext\u5c5e\u6027\u672a\u6ce8\u5165, \u8bf7\u5728applicationContext.xml\u4e2d\u5b9a\u4e49SpringContextHolder.", (Object[])new Object[0]);
    }

    public static Object getTarget(Object proxy) {
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return proxy;
        }
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            try {
                proxy = SpringContextUtil.getJdkDynamicProxyTargetObject(proxy);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u5bf9\u8c61\u9519\u8bef:", (Throwable)e);
                return proxy;
            }
        }
        try {
            proxy = SpringContextUtil.getCglibProxyTargetObject(proxy);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5bf9\u8c61\u9519\u8bef:", (Throwable)e);
            return proxy;
        }
        return SpringContextUtil.getTarget(proxy);
    }

    private static Object getCglibProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
        return target;
    }

    private static Object getJdkDynamicProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy)h.get(proxy);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
        return target;
    }

    static {
        instance = null;
    }
}

