/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;

public class SpringAopUtil {
    public static <T extends Annotation> T findMethodAnnotation(Class targetClass, Method method, Class<T> annClass) {
        Method m = method;
        Annotation a = AnnotationUtils.findAnnotation((Method)m, annClass);
        if (a != null) {
            return (T)a;
        }
        m = ClassUtils.getMostSpecificMethod((Method)m, (Class)targetClass);
        a = AnnotationUtils.findAnnotation((Method)m, annClass);
        return (T)a;
    }

    public static <T extends Annotation> T findAnnotation(Class targetClass, Class<T> annClass) {
        return (T)AnnotationUtils.findAnnotation((Class)targetClass, annClass);
    }

    public static <T extends Annotation> T findAnnotation(Class targetClass, Method method, Class<T> annClass) {
        T a = SpringAopUtil.findMethodAnnotation(targetClass, method, annClass);
        if (a != null) {
            return a;
        }
        return SpringAopUtil.findAnnotation(targetClass, annClass);
    }

    public static <T extends Annotation> T findAnnotation(JoinPoint pjp, Class<T> annClass) {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method m = signature.getMethod();
        Class<?> targetClass = pjp.getTarget().getClass();
        return SpringAopUtil.findAnnotation(targetClass, m, annClass);
    }

    public static final Map<String, Object> getMethodArgs(JoinPoint pjp) {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        String[] names = signature.getParameterNames();
        int len = names.length;
        for (int i = 0; i < len; ++i) {
            args.put(names[i], pjp.getArgs()[i]);
        }
        return args;
    }

    public static final String getMethodName(ProceedingJoinPoint pjp) {
        StringBuilder methodName = new StringBuilder(pjp.getSignature().getName()).append("(");
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        String[] names = signature.getParameterNames();
        Class[] args = signature.getParameterTypes();
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                methodName.append(",");
            }
            methodName.append(args[i].getSimpleName()).append(" ").append(names[i]);
        }
        return methodName.append(")").toString();
    }
}

