/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.serialization;

import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public class ProtostuffSerialization {
    private static Map<Class<?>, Schema<?>> cachedSchema = new ConcurrentHashMap();
    private static Objenesis objenesis = new ObjenesisStd(true);

    private static <T> Schema<T> getSchema(Class<T> clazz) {
        if (clazz == null) {
            throw new RuntimeException("\u5e8f\u5217\u5316\u5bf9\u8c61(" + clazz + ")!");
        }
        Schema schema = cachedSchema.get(clazz);
        if (schema == null && (schema = RuntimeSchema.getSchema(clazz)) != null) {
            cachedSchema.put(clazz, schema);
        }
        return schema;
    }

    public static <T> byte[] serializer(T obj) {
        Class<?> clazz = obj.getClass();
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            Schema<?> schema = ProtostuffSerialization.getSchema(clazz);
            byte[] byArray = ProtostuffIOUtil.toByteArray(obj, schema, (LinkedBuffer)buffer);
            return byArray;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        finally {
            buffer.clear();
        }
    }

    public static <T> T deserializer(byte[] data, Class<T> clazz) {
        if (data == null || data.length == 0) {
            throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38,byte\u5e8f\u5217\u4e3a\u7a7a!");
        }
        try {
            Object obj = objenesis.newInstance(clazz);
            Schema<T> schema = ProtostuffSerialization.getSchema(clazz);
            ProtostuffIOUtil.mergeFrom((byte[])data, (Object)obj, schema);
            return (T)obj;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static <T> byte[] serializeList(List<T> objList) {
        if (objList == null || objList.isEmpty()) {
            throw new RuntimeException("\u5e8f\u5217\u5316\u5bf9\u8c61\u5217\u8868(" + objList + ")\u53c2\u6570\u5f02\u5e38!");
        }
        Schema schema = RuntimeSchema.getSchema(objList.get(0).getClass());
        LinkedBuffer buffer = LinkedBuffer.allocate((int)0x100000);
        byte[] protostuff = null;
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            ProtostuffIOUtil.writeListTo((OutputStream)bos, objList, (Schema)schema, (LinkedBuffer)buffer);
            protostuff = bos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("\u5e8f\u5217\u5316\u5bf9\u8c61\u5217\u8868(" + objList + ")\u53d1\u751f\u5f02\u5e38!", e);
        }
        finally {
            buffer.clear();
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return protostuff;
    }

    public static <T> List<T> deserializeList(byte[] paramArrayOfByte, Class<T> targetClass) {
        if (paramArrayOfByte == null || paramArrayOfByte.length == 0) {
            throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38,byte\u5e8f\u5217\u4e3a\u7a7a!");
        }
        Schema schema = RuntimeSchema.getSchema(targetClass);
        List result = null;
        try {
            result = ProtostuffIOUtil.parseListFrom((InputStream)new ByteArrayInputStream(paramArrayOfByte), (Schema)schema);
        }
        catch (IOException e) {
            throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u5bf9\u8c61\u5217\u8868\u53d1\u751f\u5f02\u5e38!", e);
        }
        return result;
    }
}

