/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.serialization;

import cn.dolphin.core.serialization.Serialization;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import org.apache.commons.codec.Charsets;

public class GsonSerialization
implements Serialization {
    private static volatile Gson gson;
    private static volatile GsonSerialization gsonSerialization;

    public GsonSerialization() {
        this(FieldNamingPolicy.IDENTITY);
    }

    public GsonSerialization(FieldNamingPolicy fieldNamingPolicy) {
        GsonBuilder builder = new GsonBuilder().setFieldNamingPolicy(fieldNamingPolicy).registerTypeAdapter(Instant.class, (Object)InstantCodec.instance());
        gson = builder.create();
    }

    public static GsonSerialization getGsonSerialization() {
        if (gsonSerialization == null) {
            gsonSerialization = new GsonSerialization();
        }
        return gsonSerialization;
    }

    @Override
    public byte[] serialize(Object obj) {
        return gson.toJson(obj).getBytes(Charsets.UTF_8);
    }

    @Override
    public <T> T deserialize(byte[] in, Class<T> type) {
        return (T)gson.fromJson(new String(in, Charsets.UTF_8), type);
    }

    static {
        gsonSerialization = null;
    }

    public static class InstantCodec
    implements JsonSerializer<Instant>,
    JsonDeserializer<Instant> {
        private static final InstantCodec instance = new InstantCodec();

        public static InstantCodec instance() {
            return instance;
        }

        public Instant deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Instant.ofEpochMilli(json.getAsLong());
        }

        public JsonElement serialize(Instant src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src.toEpochMilli());
        }
    }
}

