/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.sensitive;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensitiveProcessor {
    private static final Logger log = LoggerFactory.getLogger(SensitiveProcessor.class);

    private SensitiveProcessor() {
    }

    public static SensitiveProcessor getInstance() {
        return LazySensitiveHolder.SENSITIVE_CACHE;
    }

    public void loadWordDict(String dictFilePath, Charset charset) throws IOException {
        Path path = Paths.get(dictFilePath, new String[0]);
        List<String> lines = Files.readAllLines(path, charset);
        for (String line : lines) {
            if (log.isDebugEnabled()) {
                log.debug("[\u88c5\u8f7d\u5b57\u5178] - [{}]", (Object)line);
            }
            this.add(line);
        }
    }

    public Set<String> all() {
        return LazySensitiveHolder.DICT_CACHE;
    }

    public boolean add(String keyWord) {
        return LazySensitiveHolder.DICT_CACHE.add(keyWord);
    }

    public boolean contains(String keyWord) {
        return LazySensitiveHolder.DICT_CACHE.contains(keyWord);
    }

    public boolean remove(String keyWord) {
        return LazySensitiveHolder.DICT_CACHE.remove(keyWord);
    }

    public String format(String text, String replacement) {
        if (text == null || text.length() == 0) {
            return text;
        }
        Set<String> all = this.all();
        for (String key : all) {
            text = text.replaceAll(key, replacement);
        }
        return text;
    }

    private static class LazySensitiveHolder {
        private static final SensitiveProcessor SENSITIVE_CACHE = new SensitiveProcessor();
        private static final Set<String> DICT_CACHE = new HashSet<String>();

        private LazySensitiveHolder() {
        }
    }
}

