/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.sec;

import cn.dolphin.core.sec.Base64Util;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;

public class DESedeUtil {
    public static String ALGORITHM = "DESede";
    public static int KEY_SIZE = 168;

    public static byte[] getKey(String keyCode) {
        try {
            KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM);
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(keyCode.getBytes("utf-8"));
            kg.init(KEY_SIZE, secureRandom);
            SecretKey secretKey = kg.generateKey();
            return secretKey.getEncoded();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE\u9519\u8bef");
        }
    }

    private static Key toKey(byte[] key) {
        try {
            DESedeKeySpec dks = new DESedeKeySpec(key);
            SecretKeyFactory kf = SecretKeyFactory.getInstance(ALGORITHM);
            return kf.generateSecret(dks);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE\u9519\u8bef");
        }
    }

    public static byte[] encode(byte[] data, String keyCode) {
        try {
            Key k = DESedeUtil.toKey(DESedeUtil.getKey(keyCode));
            Cipher cipher = Cipher.getInstance(ALGORITHM + "/ECB/PKCS5Padding");
            cipher.init(1, k);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE\u9519\u8bef");
        }
    }

    public static byte[] decode(byte[] data, String keyCode) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException {
        try {
            Key k = DESedeUtil.toKey(DESedeUtil.getKey(keyCode));
            Cipher cipher = Cipher.getInstance(ALGORITHM + "/ECB/PKCS5Padding");
            cipher.init(2, k);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE\u9519\u8bef");
        }
    }

    public static String encode(String text, String keyCode) {
        try {
            return Base64Util.encodeUrl(DESedeUtil.encode(text.getBytes("utf-8"), keyCode));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE\u9519\u8bef");
        }
    }

    public static String decode(String text, String keyCode) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException {
        try {
            return new String(DESedeUtil.decode(Base64Util.decode(text), keyCode), "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE\u9519\u8bef");
        }
    }
}

