/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.sec;

import cn.dolphin.core.sec.Base64Util;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class BlowfishUtil {
    public static String ALGORITHM = "Blowfish";
    public static int KEY_SIZE = 128;

    public static byte[] getKey(String keyCode) {
        try {
            KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM);
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(keyCode.getBytes("utf-8"));
            kg.init(KEY_SIZE, secureRandom);
            SecretKey secretKey = kg.generateKey();
            return secretKey.getEncoded();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE\u9519\u8bef");
        }
    }

    public static byte[] encode(byte[] data, String keyCode) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(BlowfishUtil.getKey(keyCode), ALGORITHM);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, secretKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE\u9519\u8bef");
        }
    }

    public static byte[] decode(byte[] data, String keyCode) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(BlowfishUtil.getKey(keyCode), ALGORITHM);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, secretKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE\u9519\u8bef");
        }
    }

    public static String encode(String text, String keyCode) {
        try {
            return Base64Util.encodeUrl(BlowfishUtil.encode(text.getBytes("utf-8"), keyCode));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE\u9519\u8bef");
        }
    }

    public static String decode(String text, String keyCode) {
        try {
            return new String(BlowfishUtil.decode(Base64Util.decode(text), keyCode), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE\u9519\u8bef");
        }
    }
}

