/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.sec;

import cn.dolphin.core.sec.Base64Util;
import cn.dolphin.core.sec.HexUtil;
import cn.dolphin.core.util.StrUtil;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AESUtil {
    public static String ALGORITHM = "AES";
    public static String SHA1PRNG = "SHA1PRNG";
    public static int KEY_SIZE = 128;

    public static String getKey(String keyCode) {
        try {
            KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM);
            SecureRandom secureRandom = SecureRandom.getInstance(SHA1PRNG);
            secureRandom.setSeed(keyCode.getBytes("UTF-8"));
            kg.init(KEY_SIZE, secureRandom);
            SecretKey secretKey = kg.generateKey();
            return HexUtil.encode(secretKey.getEncoded());
        }
        catch (Exception e) {
            throw new RuntimeException("\u751f\u6210AES\u5bc6\u94a5\u5931\u8d25", e);
        }
    }

    public static String getKey() {
        try {
            KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM);
            kg.init(KEY_SIZE, new SecureRandom());
            SecretKey secretKey = kg.generateKey();
            return HexUtil.encode(secretKey.getEncoded());
        }
        catch (Exception e) {
            throw new RuntimeException("\u751f\u6210AES\u5bc6\u94a5\u5931\u8d25", e);
        }
    }

    public static byte[] encode(byte[] data, String key) {
        SecretKeySpec secretKey = new SecretKeySpec(HexUtil.decode(key), ALGORITHM);
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, secretKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException("AES\u52a0\u5bc6", e);
        }
    }

    public static byte[] decode(byte[] data, String key) {
        SecretKeySpec secretKey = new SecretKeySpec(HexUtil.decode(key), ALGORITHM);
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, secretKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException("AES\u89e3\u5bc6\u5931\u8d25", e);
        }
    }

    public static String encode(String text, String key) {
        return Base64Util.encodeUrl(AESUtil.encode(StrUtil.getBytes(text), key));
    }

    public static String decode(String text, String key) {
        return StrUtil.getStr(AESUtil.decode(Base64Util.decode(text), key));
    }
}

