/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.result;

import cn.dolphin.core.page.PageList;
import cn.dolphin.core.result.PageSupport;
import cn.dolphin.core.result.ResultSupport;
import com.alibaba.fastjson.annotation.JSONType;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;

@JSONType(orders={"dec", "page", "data"})
public class PageResult<T extends Collection>
implements Serializable {
    private ResultSupport dec;
    private T data;
    private PageSupport page;

    public PageResult() {
        this.dec = new ResultSupport(){

            @Override
            public boolean isSuccess() {
                return false;
            }
        };
    }

    public PageResult(final boolean bool) {
        this.dec = new ResultSupport(){

            @Override
            public boolean isSuccess() {
                return bool;
            }
        };
    }

    public PageResult(T data, Boolean bool) {
        this(bool);
        this.dec.setCode("000000");
        this.dec.setMsg("success");
        this.data = data;
    }

    public PageResult(String code, String msg, Boolean bool) {
        this(bool);
        this.dec.setCode(code);
        this.dec.setMsg(msg);
    }

    public PageResult(String code, String msg, T data, Boolean bool) {
        this(bool);
        this.dec.setCode(code);
        this.dec.setMsg(msg);
        this.data = data;
    }

    public PageResult(PageList pageList) {
        this(pageList.getPageBean().getCurrentPage(), pageList.getPageBean().getPageSize(), pageList.getTotalPage(), pageList.getTotalCount(), pageList, true);
    }

    public PageResult(int pageNo, int pageSize, int pageCount, int totalCount, T data, Boolean bool) {
        this(bool);
        this.page = new PageSupport();
        this.dec.setCode("000000");
        this.dec.setMsg("success");
        this.page.setNumber(pageNo);
        this.page.setSize(pageSize);
        this.page.setPage(pageCount);
        this.page.setTotal(totalCount);
        this.data = data;
    }

    public static <T extends Collection> PageResult<T> success(T data) {
        if (data instanceof PageList) {
            return new PageResult<T>((PageList)data);
        }
        return new PageResult<T>(data, true);
    }

    public static <T extends Collection> PageResult<T> success(int pageNo, int pageSize, int pageCount, int totalCount, T data) {
        return new PageResult<T>(pageNo, pageSize, pageCount, totalCount, data, true);
    }

    public static <T extends Collection> PageResult<T> error(String code, String message, T data) {
        return new PageResult<T>(code, message, data, false);
    }

    public static <T extends Collection> PageResult<T> error(String code, String message) {
        return new PageResult<T>(code, message, false);
    }

    public static <T extends Collection> PageResult<T> error() {
        return new PageResult<T>("000001", "fail", false);
    }

    public ResultSupport getDec() {
        if (this.dec == null) {
            ResultSupport obj = new ResultSupport(){

                @Override
                public boolean isSuccess() {
                    return false;
                }
            };
            return obj;
        }
        return this.dec;
    }

    public void setDec(ResultSupport dec) {
        this.dec = dec;
    }

    public T getData() {
        if (this.data == null) {
            return (T)Collections.emptyList();
        }
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public PageSupport getPage() {
        return this.page;
    }

    public void setPage(PageSupport page) {
        this.page = page;
    }
}

