/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.result;

import cn.dolphin.core.json.FastJsonUtil;
import cn.dolphin.core.result.ResultSupport;
import com.alibaba.fastjson.annotation.JSONType;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;

@JSONType(orders={"dec", "data", "total"})
public class ArrayResult<T extends Collection>
implements Serializable {
    private ResultSupport dec;
    private T data;
    private Integer total = 0;

    public ArrayResult() {
        this.dec = new ResultSupport(){

            @Override
            public boolean isSuccess() {
                return false;
            }
        };
    }

    public ArrayResult(final boolean bool) {
        this.dec = new ResultSupport(){

            @Override
            public boolean isSuccess() {
                return bool;
            }
        };
    }

    public ArrayResult(T data, Boolean bool) {
        this(bool);
        this.dec.setCode("000000");
        this.dec.setMsg("success");
        this.data = data;
    }

    public ArrayResult(String code, String msg, Boolean bool) {
        this(bool);
        this.dec.setCode(code);
        this.dec.setMsg(msg);
    }

    public ArrayResult(String code, String msg, T data, Boolean bool) {
        this(bool);
        this.dec.setCode(code);
        this.dec.setMsg(msg);
        this.data = data;
    }

    public ArrayResult(T data, int totalCount, Boolean bool) {
        this(bool);
        this.dec.setCode("000000");
        this.dec.setMsg("success");
        this.total = totalCount;
        this.data = data;
    }

    public static <T extends Collection> ArrayResult<T> success(T data) {
        return new ArrayResult<T>(data, true);
    }

    public static <T extends Collection> ArrayResult<T> success(T data, int totalCount) {
        return new ArrayResult<T>(data, totalCount, (Boolean)true);
    }

    public static <T extends Collection> ArrayResult<T> error(String code, String message, T data) {
        return new ArrayResult<T>(code, message, data, false);
    }

    public static <T extends Collection> ArrayResult<T> error(String message) {
        return new ArrayResult<T>("000001", message, (Boolean)false);
    }

    public static <T extends Collection> ArrayResult<T> error(String code, String message) {
        return new ArrayResult<T>(code, message, (Boolean)false);
    }

    public static <T extends Collection> ArrayResult<T> error() {
        return new ArrayResult<T>("000001", "fail", (Boolean)false);
    }

    public String toString() {
        return FastJsonUtil.toString(this);
    }

    public ResultSupport getDec() {
        if (this.dec == null) {
            ResultSupport obj = new ResultSupport(){

                @Override
                public boolean isSuccess() {
                    return false;
                }
            };
            return obj;
        }
        return this.dec;
    }

    public void setDec(ResultSupport dec) {
        this.dec = dec;
    }

    public T getData() {
        if (this.data == null) {
            return (T)Collections.emptyList();
        }
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }
}

