/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.regex;

import cn.dolphin.core.regex.Regex;
import com.google.common.collect.Lists;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RegexUtil {
    private static final Pattern LEGAL_PATTERN = Pattern.compile("^[\\u4e00-\\u9fa5\\w\\d_.%@!\uff01\\[\\]\\\\|\\-,/,\\[\\]\\s\uff0c\u3002;\uff1b:\uff1a\u201c\u201d?\uff1f]+$");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^\\d+$");
    private static final Pattern USER_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9]{4,20}$");
    public static final Pattern REGEX_USERNAME = Pattern.compile("^[A-Za-z\\u4e00-\\u9fa5]{4,30}(?<!_)$");
    private static final Pattern PHONE_NUMBER_PATTERN = Pattern.compile("^1[345789]\\d{9}$");
    public static final Pattern REGEX_MOBILE_SIMPLE = Pattern.compile("^[1]\\d{10}$");
    public static final Pattern REGEX_MOBILE_EXACT = Pattern.compile("^1[3|4|5|6|7|8|9][0-9]\\d{8}$");
    public static final Pattern REGEX_TEL = Pattern.compile("^0\\d{2,3}[- ]?\\d{7,8}");
    private static final Pattern ALPHA_NUM = Pattern.compile("^[a-zA-Z0-9]+$");
    private static final Pattern EMPTY = Pattern.compile("^\\s*$");
    public static final Pattern REGEX_MONEY = Pattern.compile("^(([1-9]\\d*)|0)(\\.\\d{1,2})?$");
    public static final Pattern REGEX_WORD_OR_NUMBER = Pattern.compile("^[A-Za-z0-9]+$");
    public static final Pattern REGEX_ID_CARD15 = Pattern.compile("^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$");
    public static final Pattern REGEX_ID_CARD18 = Pattern.compile("^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9Xx])$");
    public static final Pattern REGEX_EMAIL = Pattern.compile("^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$");
    public static final Pattern REGEX_URL = Pattern.compile("^(http|https)://.*$");
    public static final Pattern REGEX_ZH = Pattern.compile("^[\\u4e00-\\u9fa5]+$");
    public static final Pattern REGEX_DATE = Pattern.compile("^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)$");
    public static final Pattern REGEX_IP = Pattern.compile("((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)");
    public static final Pattern REGEX_DOUBLE_BYTE_CHAR = Pattern.compile("[^\\x00-\\xff]");
    public static final Pattern REGEX_BLANK_LINE = Pattern.compile("\\n\\s*\\r");
    public static final Pattern REGEX_QQ_NUM = Pattern.compile("[1-9][0-9]{4,}");
    public static final Pattern REGEX_ZIP_CODE = Pattern.compile("[1-9]\\d{5}(?!\\d)");
    public static final Pattern REGEX_POSITIVE_INTEGER = Pattern.compile("^[1-9]\\d*$");
    public static final Pattern REGEX_NEGATIVE_INTEGER = Pattern.compile("^-[1-9]\\d*$");
    public static final Pattern REGEX_INTEGER = Pattern.compile("^-?[1-9]\\d*$");
    public static final Pattern REGEX_NOT_NEGATIVE_INTEGER = Pattern.compile("^[1-9]\\d*|0$");
    public static final Pattern REGEX_NOT_POSITIVE_INTEGER = Pattern.compile("^-[1-9]\\d*|0$");
    public static final Pattern REGEX_POSITIVE_FLOAT = Pattern.compile("^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*$");
    public static final Pattern REGEX_NEGATIVE_FLOAT = Pattern.compile("^-[1-9]\\d*\\.\\d*|-0\\.\\d*[1-9]\\d*$");

    public static boolean matcher(String content, String regExp) {
        Pattern pattern = Pattern.compile(regExp);
        Matcher matcher = pattern.matcher(content);
        return matcher.matches();
    }

    public static boolean matcher(String content, Pattern pattern) {
        Matcher matcher = pattern.matcher(content);
        return matcher.matches();
    }

    public static boolean containChinese(String s) {
        Matcher matcher;
        return s != null && !s.isEmpty() && (matcher = Pattern.compile(Regex.CHINESE.getValue()).matcher(s)).find();
    }

    public static boolean containChinese(String s, int length) {
        if (RegexUtil.containChinese(s)) {
            return s.length() <= length;
        }
        return false;
    }

    public static boolean overLengthLimit(String s, int length) {
        if (s != null) {
            return s.length() > length;
        }
        return false;
    }

    public static boolean notContainChinese(String s) {
        return !RegexUtil.containChinese(s);
    }

    public static boolean notContainIllegalParameter(String s) {
        if (s == null || s.isEmpty()) {
            return true;
        }
        Matcher matcher = LEGAL_PATTERN.matcher(s);
        return matcher.matches();
    }

    public static boolean onlyIntegerNumber(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        Matcher matcher = NUMBER_PATTERN.matcher(s);
        return matcher.matches();
    }

    public static boolean isEmail(String email) {
        if (email == null || email.length() < 1 || email.length() > 256) {
            return false;
        }
        Pattern pattern = Pattern.compile("^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$");
        return pattern.matcher(email).matches();
    }

    public static boolean isInteger(String value) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]+$");
        return pattern.matcher(value).matches();
    }

    public static boolean isDouble(String value) {
        Pattern pattern = Pattern.compile("^[-\\+]?\\d+\\.\\d+$");
        return pattern.matcher(value).matches();
    }

    public static boolean isPhoneNumber(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        Matcher matcher = PHONE_NUMBER_PATTERN.matcher(s);
        return matcher.matches();
    }

    public static boolean isChinese(String value) {
        Pattern pattern = Pattern.compile("[\u0391-\uffe5]+$");
        return pattern.matcher(value).matches();
    }

    public static boolean isUserName(String un) {
        if (StringUtils.isBlank((CharSequence)un)) {
            return false;
        }
        Matcher matcher = USER_NAME_PATTERN.matcher(un);
        return matcher.matches();
    }

    public static boolean onlyAlphaNum(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return false;
        }
        Matcher matcher = ALPHA_NUM.matcher(s);
        return matcher.matches();
    }

    public static boolean isEmpty(String s) {
        if (null == s) {
            return true;
        }
        return EMPTY.matcher(s).matches();
    }

    public static String urlDecode(String param) {
        try {
            String result;
            if (StringUtils.isNotBlank((CharSequence)param) && StringUtils.isNotBlank((CharSequence)(result = URLDecoder.decode(param, "UTF-8")))) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return param;
    }

    public static String urlEncode(String param) {
        try {
            String result;
            if (StringUtils.isNotBlank((CharSequence)param) && StringUtils.isNotBlank((CharSequence)(result = URLEncoder.encode(param, "UTF-8")))) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return param;
    }

    public static String urlEncodeOneByOne(String param) {
        String[] list = param.split("");
        StringBuilder result = new StringBuilder();
        for (String item : list) {
            if (RegexUtil.containChinese(item)) {
                result.append(RegexUtil.urlEncode(item));
                continue;
            }
            result.append(item);
        }
        return result.toString();
    }

    public static boolean containsOne(String string, String regex) {
        Pattern p1 = Pattern.compile(regex);
        Matcher m1 = p1.matcher(string);
        Integer count = 0;
        while (m1.find()) {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            if (count <= 1) continue;
            return false;
        }
        return true;
    }

    public static boolean containsMore(String string, String regex, Integer time) {
        if (time <= 0) {
            return false;
        }
        Pattern p1 = Pattern.compile(regex);
        Matcher m1 = p1.matcher(string);
        Integer count = 0;
        do {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            if (count <= time) continue;
            return true;
        } while (m1.find());
        return false;
    }

    public static List<String> gatherStringCount(String content, String regex) {
        Pattern p1 = Pattern.compile(regex);
        Matcher m1 = p1.matcher(content);
        ArrayList colgroups = Lists.newArrayList();
        while (m1.find()) {
            for (int i = 0; i < m1.groupCount(); ++i) {
                String test1 = m1.group(i);
                colgroups.add(test1);
            }
        }
        return colgroups;
    }

    private RegexUtil() {
    }
}

