/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.reflect;

import cn.dolphin.core.file.FileTypeUtil;
import cn.dolphin.core.reflect.BeanField;
import cn.dolphin.core.reflect.IFieldFilter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectUtil {
    private static final Logger logger = LoggerFactory.getLogger(ReflectUtil.class);
    private static final Map<String, List<BeanField>> BEAN_FIELD_CACHE = new HashMap<String, List<BeanField>>();
    private static final Map<String, List<Field>> FIELD_CACHE = new HashMap<String, List<Field>>();
    private static final Map<String, List<Method>> SETTER_CACHE = new HashMap<String, List<Method>>();
    private static final Map<String, List<Method>> GETTER_CACHE = new HashMap<String, List<Method>>();

    public static final List<BeanField> getBeanFields(Class clazz) {
        return ReflectUtil.getBeanFields(clazz, true, null);
    }

    public static final List<BeanField> getBeanFields(Class clazz, IFieldFilter filter) {
        return ReflectUtil.getBeanFields(clazz, true, filter);
    }

    public static final List<BeanField> getBeanFields(Class clazz, boolean superClass) {
        return ReflectUtil.getBeanFields(clazz, superClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<BeanField> getBeanFields(Class clazz, boolean superClass, IFieldFilter filter) {
        String className = clazz.getName();
        String cacheKey = className + ":" + superClass + (filter == null ? "" : ":" + filter.name());
        List<BeanField> fields = BEAN_FIELD_CACHE.get(cacheKey);
        if (fields != null) {
            return fields;
        }
        Class clazz2 = clazz;
        synchronized (clazz2) {
            Field[] declared;
            fields = BEAN_FIELD_CACHE.get(cacheKey);
            if (fields != null) {
                return fields;
            }
            fields = new ArrayList<BeanField>();
            for (Field field : declared = clazz.getDeclaredFields()) {
                int mod = field.getModifiers();
                if (Modifier.isFinal(mod) || Modifier.isStatic(mod) || filter != null && !filter.filter(field)) continue;
                fields.add(ReflectUtil.toBeanField(clazz, field));
            }
            if (superClass) {
                Class superClazz = clazz;
                while ((superClazz = superClazz.getSuperclass()) != null) {
                    Field[] lst;
                    for (Field field : lst = superClazz.getDeclaredFields()) {
                        int mod = field.getModifiers();
                        if (Modifier.isFinal(mod) || Modifier.isStatic(mod) || filter != null && !filter.filter(field)) continue;
                        boolean exists = false;
                        for (BeanField f : fields) {
                            if (!f.field.getName().equals(field.getName()) || f.field.getType() != field.getType()) continue;
                            exists = true;
                            break;
                        }
                        if (exists) continue;
                        fields.add(ReflectUtil.toBeanField(clazz, field));
                    }
                }
            }
            BEAN_FIELD_CACHE.put(cacheKey, fields);
        }
        return fields;
    }

    public static final List<Field> getFields(Class clazz) {
        return ReflectUtil.getFields(clazz, true, null);
    }

    public static final List<Field> getFields(Class clazz, IFieldFilter filter) {
        return ReflectUtil.getFields(clazz, true, filter);
    }

    public static final List<Field> getFields(Class clazz, boolean superClass) {
        return ReflectUtil.getFields(clazz, superClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<Field> getFields(Class clazz, boolean superClass, IFieldFilter filter) {
        String className = clazz.getName();
        String cacheKey = className + ":" + superClass + (filter == null ? "" : ":" + filter.name());
        List<Field> fields = FIELD_CACHE.get(cacheKey);
        if (fields != null) {
            return fields;
        }
        Class clazz2 = clazz;
        synchronized (clazz2) {
            Field[] declared;
            fields = FIELD_CACHE.get(cacheKey);
            if (fields != null) {
                return fields;
            }
            fields = new ArrayList<Field>();
            for (Field field : declared = clazz.getDeclaredFields()) {
                int mod = field.getModifiers();
                if (Modifier.isFinal(mod) || Modifier.isStatic(mod) || filter != null && !filter.filter(field)) continue;
                fields.add(field);
            }
            if (superClass) {
                Class superClazz = clazz;
                while ((superClazz = superClazz.getSuperclass()) != null) {
                    Field[] lst;
                    for (Field field : lst = superClazz.getDeclaredFields()) {
                        int mod = field.getModifiers();
                        if (Modifier.isFinal(mod) || Modifier.isStatic(mod) || filter != null && !filter.filter(field) || ReflectUtil.contains(fields, field)) continue;
                        fields.add(field);
                    }
                }
            }
            FIELD_CACHE.put(cacheKey, fields);
        }
        return fields;
    }

    public static final List<Method> getSetterMethods(Class clazz) {
        return ReflectUtil.getSetterMethods(clazz, true);
    }

    public static final List<Method> getSetterMethods(Class clazz, boolean superClass) {
        Method[] declared;
        String className = clazz.getName();
        List<Method> methods = SETTER_CACHE.get(className + ":" + superClass);
        if (methods != null) {
            return methods;
        }
        methods = new ArrayList<Method>();
        for (Method method : declared = clazz.getDeclaredMethods()) {
            int mod;
            if (!method.getName().matches("set[A-Z]\\w+") || method.getParameterCount() != 1 || Modifier.isStatic(mod = method.getModifiers())) continue;
            methods.add(method);
        }
        if (superClass) {
            Class superClazz = clazz;
            while ((superClazz = superClazz.getSuperclass()) != null) {
                Method[] lst;
                for (Method method : lst = superClazz.getDeclaredMethods()) {
                    int mod;
                    if (!method.getName().matches("set[A-Z]\\w+") || method.getParameterCount() != 1 || Modifier.isStatic(mod = method.getModifiers()) || ReflectUtil.contains(methods, method)) continue;
                    methods.add(method);
                }
            }
        }
        SETTER_CACHE.put(className + ":" + superClass, methods);
        return methods;
    }

    public static final List<Method> getGetterMethods(Class clazz) {
        return ReflectUtil.getGetterMethods(clazz, true);
    }

    public static final List<Method> getGetterMethods(Class clazz, boolean superClass) {
        Method[] declared;
        String className = clazz.getName();
        List<Method> methods = GETTER_CACHE.get(className + ":" + superClass);
        if (methods != null) {
            return methods;
        }
        methods = new ArrayList<Method>();
        for (Method method : declared = clazz.getDeclaredMethods()) {
            int mod;
            if (!method.getName().matches("(get|is)[A-Z]\\w+") || method.getParameterCount() != 0 || Modifier.isStatic(mod = method.getModifiers())) continue;
            methods.add(method);
        }
        if (superClass) {
            Class superClazz = clazz;
            while ((superClazz = superClazz.getSuperclass()) != null) {
                Method[] lst;
                for (Method method : lst = superClazz.getDeclaredMethods()) {
                    int mod;
                    if (!method.getName().matches("(get|is)[A-Z]\\w+") || method.getParameterCount() != 0 || Modifier.isStatic(mod = method.getModifiers()) || ReflectUtil.contains(methods, method)) continue;
                    methods.add(method);
                }
            }
        }
        GETTER_CACHE.put(className + ":" + superClass, methods);
        return methods;
    }

    public static final String getGetterMethodName(String fieldName) {
        return "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static final String getGetterMethodName(Field field) {
        String fieldName = field.getName();
        if (field.getType() == Boolean.TYPE || field.getType().isAssignableFrom(Boolean.class)) {
            return "is" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        }
        return ReflectUtil.getGetterMethodName(field.getName());
    }

    public static final String getSetterMethodName(String fieldName) {
        return "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static final String getSetterMethodName(Field field) {
        return ReflectUtil.getSetterMethodName(field.getName());
    }

    public static final String getFieldName(Method method) {
        String name = method.getName().replaceFirst("^(get|set|is)", "");
        if (name.isEmpty()) {
            return null;
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public static final Method getMethod(Class clazz, String method) {
        try {
            return clazz.getMethod(method, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            if (logger.isTraceEnabled()) {
                logger.trace("!No such method: {}", (Object)method);
            }
            return null;
        }
    }

    public static final Method getSetterMethod(Class clazz, String fieldName) {
        List<Method> methods = ReflectUtil.getSetterMethods(clazz);
        if (methods == null || methods.isEmpty()) {
            return null;
        }
        String name = ReflectUtil.getSetterMethodName(fieldName);
        for (Method method : methods) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public static final Method getSetterMethod(Class clazz, Field field) {
        return ReflectUtil.getSetterMethod(clazz, field.getName());
    }

    public static final Method getGetterMethod(Class clazz, String fieldName) {
        List<Method> methods = ReflectUtil.getGetterMethods(clazz);
        if (methods == null || methods.isEmpty()) {
            return null;
        }
        String name = ReflectUtil.getGetterMethodName(fieldName);
        for (Method method : methods) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public static final Method getGetterMethod(Class clazz, Field field) {
        return ReflectUtil.getGetterMethod(clazz, field.getName());
    }

    public static final Field getField(Class clazz, Method method) {
        List<Field> fields = ReflectUtil.getFields(clazz);
        if (fields == null || fields.isEmpty()) {
            return null;
        }
        String name = ReflectUtil.getFieldName(method);
        if (name == null) {
            return null;
        }
        for (Field field : fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public static final boolean contains(List<Field> list, Field field) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (Field f : list) {
            if (!f.getName().equals(field.getName()) || f.getType() != field.getType()) continue;
            return true;
        }
        return false;
    }

    protected static final boolean contains(List<Method> list, Method method) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (Method m : list) {
            if (!m.getName().equals(method.getName())) continue;
            TypeVariable<Method>[] var = m.getTypeParameters();
            TypeVariable<Method>[] var2 = method.getTypeParameters();
            if (var == null && var2 == null) {
                return true;
            }
            if (var.length != var2.length) continue;
            boolean flag = true;
            for (int i = 0; i < var.length; ++i) {
                if (var[i].getTypeName().equals(var2[i].getTypeName())) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            return true;
        }
        return false;
    }

    public static Class getGenericType(Field field) {
        ParameterizedType paramType;
        Type type = field.getGenericType();
        Class genericClazz = Map.class;
        if (type instanceof ParameterizedType && (type = (paramType = (ParameterizedType)type).getActualTypeArguments()[0]) instanceof Class) {
            genericClazz = (Class)type;
        }
        return genericClazz;
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        List<Field> fields = ReflectUtil.getFields(obj.getClass());
        if (fields != null && !fields.isEmpty()) {
            for (Field field : fields) {
                if (!field.getName().equals(fieldName)) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                Object value = null;
                try {
                    value = field.get(obj);
                }
                catch (IllegalAccessException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                return value;
            }
        }
        throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + obj + "]");
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        List<Field> fields = ReflectUtil.getFields(obj.getClass());
        if (fields != null && !fields.isEmpty()) {
            for (Field field : fields) {
                if (!field.getName().equals(fieldName)) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                try {
                    field.set(obj, value);
                }
                catch (IllegalAccessException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                return;
            }
        }
        throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + obj + "]");
    }

    private static BeanField toBeanField(Class clazz, Field field) {
        Method getter;
        Method setter;
        block9: {
            block8: {
                setter = null;
                String setterName = ReflectUtil.getSetterMethodName(field);
                try {
                    setter = clazz.getMethod(setterName, field.getType());
                }
                catch (NoSuchMethodException e) {
                    setter = ReflectUtil.getSetterMethod(clazz, field);
                    if (setter != null || !logger.isDebugEnabled()) break block8;
                    logger.debug("!No setter method: {}", (Object)field.getName());
                }
            }
            getter = null;
            String getterName = ReflectUtil.getGetterMethodName(field);
            try {
                getter = clazz.getMethod(getterName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                if (getterName.startsWith("is")) {
                    getterName = "get" + getterName.substring(2);
                    try {
                        getter = clazz.getMethod(getterName, new Class[0]);
                    }
                    catch (NoSuchMethodException ex) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("!No getter method: {}", (Object)field.getName());
                        }
                        break block9;
                    }
                }
                if (!logger.isDebugEnabled()) break block9;
                logger.debug("!No getter method: {}", (Object)field.getName());
            }
        }
        return new BeanField(field, setter, getter);
    }

    public static String getJavaTypeName(Class<?> type) {
        String typeName = type.getTypeName();
        if (typeName.indexOf(46) < 1) {
            return typeName;
        }
        if (typeName.startsWith("java.lang.") || "java.util.Date".equals(typeName) || "java.sql.Clob".equals(typeName) || "java.sql.Blob".equals(typeName) || "java.util.UUID".equals(typeName) || "java.math.BigDecimal".equals(typeName) || "java.math.BigInteger".equals(typeName)) {
            return FileTypeUtil.getFileExtName(typeName);
        }
        if (typeName.startsWith("java.sql.")) {
            return "sql" + FileTypeUtil.getFileExtName(typeName);
        }
        return typeName;
    }
}

