/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class BeanField {
    private String name;
    private Class<?> type;
    public Field field;
    public Method setter;
    public Method getter;

    public BeanField(Field field, Method setter, Method getter) {
        this.field = field;
        this.setter = setter;
        this.getter = getter;
        this.name = field.getName();
        this.type = field.getType();
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.field.getAnnotation(annotationClass);
    }

    public Method getGetterMethod() {
        return this.getter;
    }

    public Method getSetterMethod() {
        return this.setter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeanField beanField = (BeanField)o;
        return this.name.equals(beanField.getName()) && this.type == beanField.getType();
    }

    public int hashCode() {
        return this.field.hashCode();
    }
}

