/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.redis;

import cn.dolphin.core.exception.ApiException;
import cn.dolphin.core.redis.RedisBean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RedisLock {
    private static final Logger log = LoggerFactory.getLogger(RedisLock.class);

    public static boolean lock(String key, String value) {
        String oldValue;
        if (RedisBean.getInstance().getRedisTemplate().opsForValue().setIfAbsent((Object)key, (Object)value).booleanValue()) {
            return true;
        }
        String currentValue = (String)RedisBean.getInstance().getRedisTemplate().opsForValue().get((Object)key);
        return !StringUtils.isEmpty((CharSequence)currentValue) && Long.parseLong(currentValue) < System.currentTimeMillis() && !StringUtils.isEmpty((CharSequence)(oldValue = (String)RedisBean.getInstance().getRedisTemplate().opsForValue().getAndSet((Object)key, (Object)value))) && oldValue.equals(currentValue);
    }

    public static void unlock(String key, String value) {
        try {
            String currentValue = (String)RedisBean.getInstance().getRedisTemplate().opsForValue().get((Object)key);
            if (!StringUtils.isEmpty((CharSequence)currentValue) && currentValue.equals(value)) {
                RedisBean.getInstance().getRedisTemplate().opsForValue().getOperations().delete((Object)key);
            }
        }
        catch (Exception e) {
            throw new ApiException("redis\u5206\u5e03\u5f0f\u9501,\u89e3\u9501\u5f02\u5e38,{}", e);
        }
    }
}

