/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.redis;

import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class ProtoStuffSerializerUtil {
    public static <T> byte[] serialize(T obj) {
        if (obj == null) {
            throw new RuntimeException("\u5e8f\u5217\u5316\u5bf9\u8c61(" + obj + ")!");
        }
        Schema schema = RuntimeSchema.getSchema(obj.getClass());
        LinkedBuffer buffer = LinkedBuffer.allocate((int)0x100000);
        byte[] protostuff = null;
        try {
            protostuff = ProtostuffIOUtil.toByteArray(obj, (Schema)schema, (LinkedBuffer)buffer);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5e8f\u5217\u5316(" + obj.getClass() + ")\u5bf9\u8c61(" + obj + ")\u53d1\u751f\u5f02\u5e38!", e);
        }
        finally {
            buffer.clear();
        }
        return protostuff;
    }

    public static <T> T deserialize(byte[] paramArrayOfByte, Class<T> targetClass) {
        if (paramArrayOfByte == null || paramArrayOfByte.length == 0) {
            throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38,byte\u5e8f\u5217\u4e3a\u7a7a!");
        }
        T instance = null;
        try {
            instance = targetClass.newInstance();
        }
        catch (InstantiationException e1) {
            throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u8fc7\u7a0b\u4e2d\u4f9d\u636e\u7c7b\u578b\u521b\u5efa\u5bf9\u8c61\u5931\u8d25!", e1);
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u8fc7\u7a0b\u4e2d\u4f9d\u636e\u7c7b\u578b\u521b\u5efa\u5bf9\u8c61\u5931\u8d25!", e2);
        }
        Schema schema = RuntimeSchema.getSchema(targetClass);
        ProtostuffIOUtil.mergeFrom((byte[])paramArrayOfByte, instance, (Schema)schema);
        return instance;
    }

    public static <T> byte[] serializeList(List<T> objList) {
        if (objList == null || objList.isEmpty()) {
            throw new RuntimeException("\u5e8f\u5217\u5316\u5bf9\u8c61\u5217\u8868(" + objList + ")\u53c2\u6570\u5f02\u5e38!");
        }
        Schema schema = RuntimeSchema.getSchema(objList.get(0).getClass());
        LinkedBuffer buffer = LinkedBuffer.allocate((int)0x100000);
        byte[] protostuff = null;
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            ProtostuffIOUtil.writeListTo((OutputStream)bos, objList, (Schema)schema, (LinkedBuffer)buffer);
            protostuff = bos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("\u5e8f\u5217\u5316\u5bf9\u8c61\u5217\u8868(" + objList + ")\u53d1\u751f\u5f02\u5e38!", e);
        }
        finally {
            buffer.clear();
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return protostuff;
    }

    public static <T> List<T> deserializeList(byte[] paramArrayOfByte, Class<T> targetClass) {
        if (paramArrayOfByte == null || paramArrayOfByte.length == 0) {
            throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38,byte\u5e8f\u5217\u4e3a\u7a7a!");
        }
        Schema schema = RuntimeSchema.getSchema(targetClass);
        List result = null;
        try {
            result = ProtostuffIOUtil.parseListFrom((InputStream)new ByteArrayInputStream(paramArrayOfByte), (Schema)schema);
        }
        catch (IOException e) {
            throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u5bf9\u8c61\u5217\u8868\u53d1\u751f\u5f02\u5e38!", e);
        }
        return result;
    }
}

