/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Base64OutputStream;

public class QRCodeUtil {
    public static final String QRCODE_DEFAULT_CHARSET = "UTF-8";
    public static final int QRCODE_DEFAULT_HEIGHT = 150;
    public static final int QRCODE_DEFAULT_WIDTH = 150;
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;

    public static void main(String[] args) throws IOException, NotFoundException {
        String data = "http://www.baidu.com";
        File logoFile = new File("E:/pic/64.jpg");
        BufferedImage image = QRCodeUtil.createQRCodeWithLogo(data, 400, 400, logoFile);
        ImageIO.write((RenderedImage)image, "png", new File("E:/pic/64a.png"));
    }

    public static BufferedImage createQRCode(String data) {
        return QRCodeUtil.createQRCode(data, 150, 150);
    }

    public static BufferedImage createQRCode(String data, int width, int height) {
        return QRCodeUtil.createQRCode(data, QRCODE_DEFAULT_CHARSET, width, height);
    }

    public static BufferedImage createQRCode(String data, String charset, int width, int height) {
        HashMap<EncodeHintType, Object> hint = new HashMap<EncodeHintType, Object>();
        hint.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hint.put(EncodeHintType.CHARACTER_SET, charset);
        return QRCodeUtil.createQRCode(data, charset, hint, width, height);
    }

    public static BufferedImage createQRCode(String data, String charset, Map<EncodeHintType, ?> hint, int width, int height) {
        try {
            BitMatrix matrix = new MultiFormatWriter().encode(new String(data.getBytes(charset), charset), BarcodeFormat.QR_CODE, width, height, hint);
            return QRCodeUtil.toBufferedImage(matrix);
        }
        catch (WriterException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static BufferedImage createQRCodeWithLogo(String data, File logoFile) {
        return QRCodeUtil.createQRCodeWithLogo(data, 150, 150, logoFile);
    }

    public static BufferedImage createQRCodeWithLogo(String data, int width, int height, File logoFile) {
        return QRCodeUtil.createQRCodeWithLogo(data, QRCODE_DEFAULT_CHARSET, width, height, logoFile);
    }

    public static BufferedImage createQRCodeWithLogo(String data, String charset, int width, int height, File logoFile) {
        HashMap<EncodeHintType, Object> hint = new HashMap<EncodeHintType, Object>();
        hint.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hint.put(EncodeHintType.CHARACTER_SET, charset);
        return QRCodeUtil.createQRCodeWithLogo(data, charset, hint, width, height, logoFile);
    }

    public static BufferedImage createQRCodeWithLogo(String data, String charset, Map<EncodeHintType, ?> hint, int width, int height, File logoFile) {
        try {
            BufferedImage qrcode = QRCodeUtil.createQRCode(data, charset, hint, width, height);
            BufferedImage logo = ImageIO.read(logoFile);
            int deltaHeight = height - logo.getHeight();
            int deltaWidth = width - logo.getWidth();
            BufferedImage combined = new BufferedImage(height, width, 2);
            Graphics2D g = (Graphics2D)combined.getGraphics();
            g.drawImage((Image)qrcode, 0, 0, null);
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g.drawImage((Image)logo, Math.round(deltaWidth / 2), Math.round(deltaHeight / 2), null);
            return combined;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String getImageBase64String(BufferedImage image) {
        String result = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Base64OutputStream b64 = new Base64OutputStream((OutputStream)os);
            ImageIO.write((RenderedImage)image, "png", (OutputStream)b64);
            result = os.toString(QRCODE_DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return result;
    }

    public static void convertBase64StringToImage(String base64ImageString, File file) {
        try {
            Base64 d = new Base64();
            byte[] bs = d.decode(base64ImageString);
            FileOutputStream os = new FileOutputStream(file.getAbsolutePath());
            os.write(bs);
            os.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static BufferedImage toBufferedImage(BitMatrix matrix) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }
}

