/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class PropertyConfigUtil
extends PropertyResourceConfigurer {
    private Logger log = LoggerFactory.getLogger(PropertyConfigUtil.class);
    private PathMatchingResourcePatternResolver resourceLoader = new PathMatchingResourcePatternResolver();
    private static Map<String, String> ctxPropertiesMap;

    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) throws BeansException {
        this.log.debug("PropertyConfigure execute ........");
        InputStream in = null;
        Properties properties = new Properties();
        try {
            Resource[] resources;
            for (Resource resource : resources = this.resourceLoader.getResources("classpath:/**/*.properties")) {
                in = resource.getInputStream();
                properties.load(in);
            }
        }
        catch (IOException e) {
            this.log.error("load properties error!!!");
        }
        ctxPropertiesMap = new HashMap<String, String>();
        for (Map.Entry<Object, Object> key : properties.entrySet()) {
            String keyStr = (String)key.getKey();
            String value = (String)key.getValue();
            ctxPropertiesMap.put(keyStr, value);
            this.log.debug("PropertyConfigure load K[{}] V[{}]", (Object)keyStr, (Object)value);
        }
        this.log.info("PropertyConfigure load finish,size:{}", (Object)ctxPropertiesMap.size());
    }

    public static String getProperty(String name) {
        return ctxPropertiesMap.get(name);
    }

    public static String getProperty(String name, String value) {
        String v = ctxPropertiesMap.get(name);
        if (StringUtils.isEmpty((CharSequence)v)) {
            return value;
        }
        return ctxPropertiesMap.get(name);
    }
}

