/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.plugin.baidu;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaiduMapApi {
    private static final Logger log = LoggerFactory.getLogger(BaiduMapApi.class);
    private static String accessKey = "gV7ex9D4tvMxataH82p4B1ULD8hL2oKW";
    private static final String LAT = "lat";
    private static final String LNG = "lng";
    private static InputStreamReader isr = null;

    public static Map<String, Double> getLatAndLng(String address) {
        HashMap<String, Double> lngAnglatMap = new HashMap<String, Double>();
        StringBuilder url = new StringBuilder("http://api.map.baidu.com/geocoder/v2/?address=").append(address).append("&output=json&ak=").append(accessKey);
        try {
            String json = BaiduMapApi.loadJSON(url.toString());
            JSONObject object = JSONObject.parseObject((String)json);
            String statusCode = object.getInteger("status").toString();
            if ("0".equals(statusCode)) {
                double lng = object.getJSONObject("result").getJSONObject("location").getDouble(LNG);
                lngAnglatMap.put(LNG, lng);
                double lat = object.getJSONObject("result").getJSONObject("location").getDouble(LAT);
                lngAnglatMap.put(LAT, lat);
            } else {
                log.warn("BaiduMapService", (Object)("\u767e\u5ea6\u63a5\u53e3\u670d\u52a1\u72b6\u6001\u7801\u9519\u8bef\uff1a" + statusCode));
            }
        }
        catch (Exception e) {
            log.error("BaiduMapService", (Throwable)e);
        }
        return lngAnglatMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadJSON(String url) {
        String json = null;
        try {
            URL mapAPI = new URL(url);
            URLConnection connection = mapAPI.openConnection();
            isr = new InputStreamReader(connection.getInputStream(), "utf-8");
            json = IOUtils.toString((Reader)isr);
        }
        catch (Exception e) {
            log.error("BaiduMapService", (Throwable)e);
        }
        finally {
            try {
                isr.close();
            }
            catch (IOException e) {
                log.error("BaiduMapService", (Throwable)e);
            }
        }
        return json;
    }
}

