/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.performance;

import cn.dolphin.core.performance.BussinessHandler;
import cn.dolphin.core.performance.DefaultRunnable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PerformanceUtil {
    private int poolSize = 100;
    private long timeStart = 0L;
    private long timeEnd = 0L;
    private long processedRequestsStart = 0L;
    private long processedRequestsEnd = 0L;
    private BussinessHandler handler;

    public void execute() {
        try {
            ExecutorService pool = Executors.newCachedThreadPool();
            DefaultRunnable.setHandler(this.handler);
            DefaultRunnable runnable = new DefaultRunnable();
            for (int i = 0; i < this.poolSize; ++i) {
                pool.execute(runnable);
            }
            while (true) {
                this.timeStart = System.currentTimeMillis();
                this.processedRequestsStart = DefaultRunnable.processedRequests.get();
                Thread.sleep(2000L);
                this.processedRequestsEnd = DefaultRunnable.processedRequests.get();
                this.timeEnd = System.currentTimeMillis();
                double disCount = this.processedRequestsEnd - this.processedRequestsStart;
                double disTime = this.timeEnd - this.timeStart;
                double perMs = disCount / disTime;
                long perS = (long)(perMs * 1000.0);
                System.out.println("\u6bcf\u79d2\u6267\u884c\u4e8b\u52a1\u6570:" + perS);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setHandler(BussinessHandler handler) {
        this.handler = handler;
    }
}

