/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.page.cache;

import cn.dolphin.core.page.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class GuavaCache<K, V>
implements Cache<K, V> {
    private final com.google.common.cache.Cache<K, V> CACHE;

    public GuavaCache(Properties properties, String prefix) {
        String initialCapacity;
        String expireAfterWrite;
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        String maximumSize = properties.getProperty(prefix + "maximumSize");
        if (StringUtils.isNotEmpty((CharSequence)maximumSize)) {
            cacheBuilder.maximumSize(Long.parseLong(maximumSize));
        } else {
            cacheBuilder.maximumSize(1000L);
        }
        String expireAfterAccess = properties.getProperty(prefix + "expireAfterAccess");
        if (StringUtils.isNotEmpty((CharSequence)expireAfterAccess)) {
            cacheBuilder.expireAfterAccess(Long.parseLong(expireAfterAccess), TimeUnit.MILLISECONDS);
        }
        if (StringUtils.isNotEmpty((CharSequence)(expireAfterWrite = properties.getProperty(prefix + "expireAfterWrite")))) {
            cacheBuilder.expireAfterWrite(Long.parseLong(expireAfterWrite), TimeUnit.MILLISECONDS);
        }
        if (StringUtils.isNotEmpty((CharSequence)(initialCapacity = properties.getProperty(prefix + "initialCapacity")))) {
            cacheBuilder.initialCapacity(Integer.parseInt(initialCapacity));
        }
        this.CACHE = cacheBuilder.build();
    }

    @Override
    public V get(K key) {
        return (V)this.CACHE.getIfPresent(key);
    }

    @Override
    public void put(K key, V value) {
        this.CACHE.put(key, value);
    }
}

