/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.page.cache;

import cn.dolphin.core.exception.DaoRuntimException;
import cn.dolphin.core.page.cache.Cache;
import cn.dolphin.core.page.cache.GuavaCache;
import java.lang.reflect.Constructor;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public abstract class CacheFactory {
    public static <K, V> Cache<K, V> createCache(String cacheClass, String prefix, Properties properties) {
        if (StringUtils.isEmpty((CharSequence)cacheClass)) {
            cacheClass = "com.google.common.cache.Cache";
            try {
                Class.forName(cacheClass);
                return new GuavaCache(properties, prefix);
            }
            catch (Throwable t) {
                throw new DaoRuntimException("Created cache [" + cacheClass + "] Error", t);
            }
        }
        try {
            Class<?> clazz = Class.forName(cacheClass);
            try {
                Constructor<?> constructor = clazz.getConstructor(Properties.class, String.class);
                return (Cache)constructor.newInstance(properties, prefix);
            }
            catch (Exception e) {
                return (Cache)clazz.newInstance();
            }
        }
        catch (Throwable t) {
            throw new DaoRuntimException("Created Cache [" + cacheClass + "] Error", t);
        }
    }
}

