/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.page;

import cn.dolphin.core.dto.Dto;
import cn.dolphin.core.map.MapUtil;
import cn.dolphin.core.page.PageBean;
import cn.dolphin.core.web.util.RequestUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryFilter {
    private Logger logger = LoggerFactory.getLogger(QueryFilter.class);
    private Map<String, Object> filters = new HashMap<String, Object>();
    private String sortColumns = "";
    private PageBean pageBean = null;
    private HttpServletRequest request;

    public QueryFilter(Map<String, Object> map) {
        this(map, true, true);
    }

    public QueryFilter(Dto dto) {
        this(dto, true, true);
    }

    public QueryFilter(Map<String, Object> map, boolean needPage) {
        this(map, needPage, true);
    }

    public QueryFilter(Dto dto, boolean needPage) {
        this(dto, needPage, true);
    }

    public QueryFilter(Map<String, Object> map, boolean needPage, boolean showTotal) {
        if (needPage) {
            int page = MapUtil.getInteger(map, "page", 1);
            int pageSize = MapUtil.getInteger(map, "pageSize", 10);
            this.pageBean = new PageBean(page, pageSize);
            this.pageBean.setShowTotal(showTotal);
        }
        this.filters = map;
    }

    public QueryFilter(Dto dto, boolean needPage, boolean showTotal) {
        if (needPage) {
            int page = MapUtil.getInteger(dto, "page", 1);
            int pageSize = MapUtil.getInteger(dto, "pageSize", 10);
            this.pageBean = new PageBean(page, pageSize);
            this.pageBean.setShowTotal(showTotal);
        }
        this.filters = dto;
    }

    public QueryFilter(Dto dto, int page, int pageSize) {
        this(dto, page, pageSize, true);
    }

    public QueryFilter(Map<String, Object> map, int page, int pageSize) {
        this(map, page, pageSize, true);
    }

    public QueryFilter(Map<String, Object> map, int page, int pageSize, boolean showTotal) {
        this.pageBean = new PageBean(page, pageSize);
        this.pageBean.setShowTotal(showTotal);
        this.filters = map;
    }

    public QueryFilter(Dto dto, int page, int pageSize, boolean showTotal) {
        this.pageBean = new PageBean(page, pageSize);
        this.pageBean.setShowTotal(showTotal);
        this.filters = dto;
    }

    public QueryFilter(HttpServletRequest request, boolean needPage) {
        this.request = request;
        try {
            if (needPage) {
                int page = RequestUtil.getInt(request, "page", 1);
                int pageSize = RequestUtil.getInt(request, "pageSize", 10);
                this.pageBean = new PageBean(page, pageSize);
                this.pageBean.setShowTotal(true);
            }
            Map<String, Object> map = RequestUtil.getParams(request);
            this.filters = map;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
        }
    }

    public void addFilter(String filterName, Object params) {
        this.filters.put(filterName, params);
    }

    public Map<String, Object> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, Object> filters) {
        this.filters = filters;
    }

    public String getSortColumns() {
        return this.sortColumns;
    }

    public void setSortColumns(String sortColumns) {
        this.sortColumns = sortColumns;
    }

    public PageBean getPageBean() {
        return this.pageBean;
    }

    public void setPageBean(PageBean pageBean) {
        this.pageBean = pageBean;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }
}

