/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.page;

import cn.dolphin.core.map.MapUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PageUtils {
    private static final Logger log = LoggerFactory.getLogger(PageUtils.class);
    public static final String PAGE = "page";
    public static final String LIMIT = "pageSize";

    private PageUtils() {
    }

    public static void pageParamConver(Map<String, Object> params, boolean required) {
        if (!(!required || params != null && params.containsKey(PAGE) && params.containsKey(LIMIT))) {
            throw new IllegalArgumentException("\u8bf7\u68c0\u67e5\u5206\u9875\u53c2\u6570,page,pageSize");
        }
        if (!CollectionUtils.isEmpty(params)) {
            if (params.containsKey(PAGE)) {
                Integer start = MapUtil.getInteger(params, PAGE, 1);
                Integer length = MapUtil.getInteger(params, LIMIT, 10);
                if (start < 0) {
                    log.error("page\uff1a{}\uff0c\u91cd\u7f6e\u4e3a0", (Object)start);
                    start = 0;
                }
                params.put(PAGE, (start - 1) * length);
            }
            if (params.containsKey(LIMIT)) {
                Integer length = MapUtil.getInteger(params, LIMIT, 10);
                if (length < 0) {
                    log.error("limit\uff1a{}\uff0c\u91cd\u7f6e\u4e3a0", (Object)length);
                    length = 0;
                }
                params.put(LIMIT, length);
            }
        }
    }

    public static int getFirstNumber(int currentPage, int pageSize) {
        if (currentPage <= 0) {
            currentPage = 1;
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException("[pageSize] must great than zero");
        }
        return (currentPage - 1) * pageSize;
    }

    public static int getLastNumber(int currentPage, int pageSize, int totalCount) {
        int last = currentPage * pageSize;
        if (last > totalCount) {
            return totalCount;
        }
        return last;
    }

    public static List<Integer> getPageNumbers(int currentPage, int totalPage, int count) {
        int endPage;
        int avg = count / 2;
        int startPage = currentPage - avg;
        if (startPage <= 0) {
            startPage = 1;
        }
        if ((endPage = startPage + count - 1) > totalPage) {
            endPage = totalPage;
        }
        if (endPage - startPage < count && (startPage = endPage - count) <= 0) {
            startPage = 1;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = startPage; i <= endPage; ++i) {
            result.add(new Integer(i));
        }
        return result;
    }

    public static int getTotalPage(int totalCount, int pageSize) {
        int result;
        int n = result = totalCount % pageSize == 0 ? totalCount / pageSize : totalCount / pageSize + 1;
        if (result <= 1) {
            result = 1;
        }
        return result;
    }

    public static int getPageNumber(int currentPage, int pageSize, int totalCount) {
        if (currentPage <= 1) {
            return 1;
        }
        if (Integer.MAX_VALUE == currentPage || currentPage > PageUtils.getTotalPage(totalCount, pageSize)) {
            return PageUtils.getTotalPage(totalCount, pageSize);
        }
        return currentPage;
    }
}

