/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.order;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SnowFlake {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnowFlake.class);
    private static final long START_TIMESTAMP = 1511435554743L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long MACHINE_ID_BITS = 5L;
    private static final long DATACENTER_ID_BITS = 5L;
    private static final long MAX_DATACENTER_ID = 31L;
    private static final long MAX_MACHINE_ID = 31L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long MACHINE_LEFT = 12L;
    private static final long DATACENTER_LEFT = 17L;
    private static final long TIMESTAMP_LEFT = 22L;
    private long datacenterId;
    private long machineId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private long maxTimeDifference = 5000L;

    public SnowFlake(long datacenterId, long machineId) {
        if (datacenterId > 31L || datacenterId < 0L) {
            String msg = String.format("datacenterId can't be greater than %d or less than 0", 31L);
            throw new IllegalArgumentException(msg);
        }
        if (machineId > 31L || machineId < 0L) {
            String msg = String.format("machineId can't be greater than %d or less than 0", 31L);
            throw new IllegalArgumentException(msg);
        }
        this.datacenterId = datacenterId;
        this.machineId = machineId;
    }

    public SnowFlake(long datacenterId, long machineId, long maxTimeDifference) {
        this(datacenterId, machineId);
        this.maxTimeDifference = maxTimeDifference;
    }

    public synchronized long nextId() {
        long currentTimestamp = this.getTimestamp();
        if (currentTimestamp < this.lastTimestamp) {
            String msg = "Clock moved backwards.";
            LOGGER.warn(msg);
            currentTimestamp = this.lastTimestamp;
        }
        if (currentTimestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currentTimestamp = this.getNextMillis();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = currentTimestamp;
        return currentTimestamp - 1511435554743L << 22 | this.datacenterId << 17 | this.machineId << 12 | this.sequence;
    }

    private long getNextMillis() {
        long timestamp = this.getTimestamp();
        while (this.lastTimestamp - timestamp >= this.maxTimeDifference) {
            String msg = "The difference between last timestamp and current timestamp is great or equal to " + this.maxTimeDifference + " millis.";
            LOGGER.warn(msg);
            timestamp = this.getTimestamp();
        }
        if (this.lastTimestamp - timestamp >= 0L) {
            timestamp = this.lastTimestamp + 1L;
        }
        return timestamp;
    }

    private long getTimestamp() {
        return System.currentTimeMillis();
    }
}

