/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.order;

import cn.dolphin.core.util.RandomUtil;
import cn.dolphin.core.util.ValidateUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderGenerater {
    private static final Logger LOG = LoggerFactory.getLogger(OrderGenerater.class);
    private static volatile int serialNo = 0;
    private static final String FORMATSTRING = "yyMMddHHmmssSSS";
    private static final Lock lock = new ReentrantLock(true);
    private static final int TIMEOUTSECODES = 3;

    private OrderGenerater() {
    }

    public static String generatorOrderNumber() {
        String date = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String orderConstant01 = "00001000";
        String twoRandom01 = OrderGenerater.generatorTowRandom();
        String orderConstant02 = "00";
        String seconds = new SimpleDateFormat("HHmmss").format(new Date());
        String twoRandom02 = OrderGenerater.generatorTowRandom();
        return date + orderConstant01 + twoRandom01 + orderConstant02 + seconds + twoRandom02;
    }

    public static String generatorTowRandom() {
        Random random = new Random();
        String result = String.valueOf(random.nextInt(100));
        if (result.length() == 1) {
            result = "0" + result;
        }
        return result;
    }

    public static String generateOrder() {
        StringBuilder builder = new StringBuilder();
        builder.append(OrderGenerater.getDateTime(FORMATSTRING)).append(OrderGenerater.getNumberFromMechine()).append(OrderGenerater.getRandomNum()).append(OrderGenerater.getIncrement());
        return builder.toString();
    }

    public static String generateOrder(String prefix, int len) {
        StringBuilder builder = new StringBuilder(prefix);
        builder.append(RandomUtil.getRandomUuidStr(len - prefix.length()));
        return builder.toString();
    }

    private static String getDateTime(String formatStr) {
        SimpleDateFormat format = new SimpleDateFormat(formatStr);
        return format.format(new Date());
    }

    private static String getIncrement() {
        int tempSerialNo;
        block7: {
            tempSerialNo = 0;
            try {
                if (lock.tryLock(3L, TimeUnit.SECONDS)) {
                    serialNo = serialNo >= 99 ? 0 : ++serialNo;
                    tempSerialNo = serialNo;
                    break block7;
                }
                LOG.error("can not get lock in:{} seconds!", (Object)3);
                throw new RuntimeException("generateOrder can not get lock!");
            }
            catch (Exception e) {
                LOG.error("tryLock throws Exception:", (Throwable)e);
                throw new RuntimeException("tryLock throws Exception!");
            }
            finally {
                lock.unlock();
            }
        }
        if (tempSerialNo < 10) {
            return "0" + tempSerialNo;
        }
        return "" + tempSerialNo;
    }

    private static String getRandomNum() {
        int num = new Random(System.nanoTime()).nextInt(100);
        if (num < 10) {
            return "0" + num;
        }
        return num + "";
    }

    private static String getNumberFromMechine() {
        String hostName = "";
        try {
            hostName = OrderGenerater.getHostName();
        }
        catch (Exception e) {
            LOG.error("getHostName throws Exception:", (Throwable)e);
        }
        if (StringUtils.isBlank((CharSequence)hostName) || hostName.length() < 2) {
            LOG.warn("hostName:{} is illegal!return randomNum!", (Object)hostName);
            return OrderGenerater.getRandomNum();
        }
        String number = hostName.substring(hostName.length() - 2, hostName.length());
        if (ValidateUtil.isPoInteger(number)) {
            return number;
        }
        LOG.warn("number:{} is not number!return randomNum!", (Object)number);
        return OrderGenerater.getRandomNum();
    }

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("getLocalHost throws UnknownHostException:", (Throwable)e);
            return "";
        }
    }
}

