/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.order;

import cn.dolphin.core.date.DateFormatUtil;
import cn.dolphin.core.order.SnowFlake;
import cn.dolphin.core.order.SnowFlakeUtils;
import cn.dolphin.core.util.RandomUtil;
import java.util.Date;

public class GenerateOrderNoUtil {
    public static String getOrderNo(int length) {
        String result = "";
        if (length <= 0) {
            return result;
        }
        SnowFlake snowFlake = SnowFlakeUtils.getInstance(0L, length, "LOAN");
        long snowRandowmId = snowFlake.nextId();
        String snowRandowmIdStr = String.valueOf(snowRandowmId);
        int randomLength = snowRandowmIdStr.length();
        if (length < randomLength) {
            result = RandomUtil.getRandomUuidStr(length);
        } else {
            int paddingLen = length - randomLength;
            result = GenerateOrderNoUtil.paddingStr(snowRandowmIdStr, '0', paddingLen);
        }
        return result;
    }

    public static String getOrderNoWithDate(int length) {
        String dateStr = DateFormatUtil.format(new Date(), "yyyyMMdd");
        String randomStr = GenerateOrderNoUtil.getOrderNo(length - 8);
        return dateStr + randomStr;
    }

    private static String paddingStr(String source, char c, int paddingLen) {
        StringBuffer sb = new StringBuffer(source);
        for (int i = 0; i < paddingLen; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }
}

