/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.mybatis.typehandler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class ListTypeHandler
extends BaseTypeHandler<List<String>> {
    public void setNonNullParameter(PreparedStatement ps, int i, List<String> parameter, JdbcType jdbcType) throws SQLException {
        StringBuilder arrayBuilder = new StringBuilder();
        if (parameter != null && parameter.size() > 0) {
            for (String val : parameter) {
                arrayBuilder.append(",");
                arrayBuilder.append(val);
            }
            arrayBuilder.deleteCharAt(0);
        }
        ps.setString(i, arrayBuilder.toString());
    }

    public List<String> getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.getArray(rs.getString(columnName));
    }

    public List<String> getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.getArray(rs.getString(columnIndex));
    }

    public List<String> getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.getArray(cs.getString(columnIndex));
    }

    private List<String> getArray(String array) {
        if (array == null) {
            return null;
        }
        try {
            String[] arrays = array.split(",");
            ArrayList<String> list = new ArrayList<String>();
            Collections.addAll(list, arrays);
            return list;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

