/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.mybatis.typehandler;

import cn.dolphin.core.util.EmptyUtil;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedJdbcTypes(value={JdbcType.INTEGER})
@MappedTypes(value={Object.class})
public class IntegerTypeHandler
extends BaseTypeHandler<Object> {
    private static Logger logger = LoggerFactory.getLogger(IntegerTypeHandler.class);

    public Object getNullableResult(ResultSet resultSet, String arg1) throws SQLException {
        return resultSet.getInt(arg1);
    }

    public Object getNullableResult(ResultSet resultSet, int arg1) throws SQLException {
        return resultSet.getInt(arg1);
    }

    public Object getNullableResult(CallableStatement callableStatement, int arg1) throws SQLException {
        return callableStatement.getInt(arg1);
    }

    public void setNonNullParameter(PreparedStatement preparedStatement, int arg1, Object arg2, JdbcType arg3) throws SQLException {
        Integer value = null;
        if (EmptyUtil.isNotEmpty(arg2).booleanValue()) {
            if (arg2 instanceof Integer) {
                value = (Integer)arg2;
            } else if (arg2 instanceof Long) {
                value = (Integer)arg2;
            } else if (arg2 instanceof String) {
                try {
                    value = Integer.parseInt(arg2.toString());
                }
                catch (NumberFormatException e) {
                    logger.error("\u8f6c\u6362\u5931\u8d25!\u8fd4\u56denull", (Throwable)e);
                    value = null;
                }
            }
        }
        if (null == value) {
            preparedStatement.setNull(arg1, 4);
        } else {
            preparedStatement.setInt(arg1, value);
        }
    }
}

