/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.mybatis.typehandler;

import cn.dolphin.core.mybatis.enums.CodeBaseEnum;
import cn.dolphin.core.mybatis.util.CodeEnumUtil;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class EnumTypeHandler<E extends Enum<?>>
extends BaseTypeHandler<CodeBaseEnum> {
    private Class<E> clazz;

    public EnumTypeHandler(Class<E> enumType) {
        if (enumType == null) {
            throw new IllegalArgumentException("Type argument cannot be null");
        }
        this.clazz = enumType;
    }

    public void setNonNullParameter(PreparedStatement ps, int i, CodeBaseEnum parameter, JdbcType jdbcType) throws SQLException {
        ps.setInt(i, parameter.code());
    }

    public E getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return CodeEnumUtil.codeOf(this.clazz, rs.getInt(columnName));
    }

    public E getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return CodeEnumUtil.codeOf(this.clazz, rs.getInt(columnIndex));
    }

    public E getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return CodeEnumUtil.codeOf(this.clazz, cs.getInt(columnIndex));
    }
}

