/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.mybatis.typehandler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class ArrayTypeHandler
extends BaseTypeHandler<String[]> {
    public void setNonNullParameter(PreparedStatement ps, int i, String[] parameter, JdbcType jdbcType) throws SQLException {
        StringBuilder arrayBuilder = new StringBuilder();
        if (parameter != null && parameter.length > 0) {
            for (String val : parameter) {
                arrayBuilder.append(",");
                arrayBuilder.append(val);
            }
            arrayBuilder.deleteCharAt(0);
        }
        ps.setString(i, arrayBuilder.toString());
    }

    public String[] getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.getArray(rs.getString(columnName));
    }

    public String[] getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.getArray(rs.getString(columnIndex));
    }

    public String[] getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.getArray(cs.getString(columnIndex));
    }

    private String[] getArray(String array) {
        if (array == null) {
            return null;
        }
        try {
            return array.split(",");
        }
        catch (Exception exception) {
            return null;
        }
    }
}

