/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.mybatis.plugin;

import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.defaults.DefaultSqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(args={Statement.class, ResultHandler.class}, method="query", type=StatementHandler.class), @Signature(args={Statement.class}, method="update", type=StatementHandler.class), @Signature(args={Statement.class}, method="batch", type=StatementHandler.class)})
public class SqlCastInInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(SqlCastInInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        long startTime = System.currentTimeMillis();
        StatementHandler statementHandler = (StatementHandler)target;
        int size = 0;
        try {
            Object o = invocation.proceed();
            if (this.isList(o.getClass())) {
                size = ((List)o).size();
            }
            Object object = o;
            return object;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long sqlCost = endTime - startTime;
            BoundSql boundSql = statementHandler.getBoundSql();
            String sql = boundSql.getSql();
            Object parameterObject = boundSql.getParameterObject();
            List parameterMappingList = boundSql.getParameterMappings();
            sql = this.formatSql(sql, parameterObject, parameterMappingList);
            log.info("SQL\uff1a[" + sql + "]\u6267\u884c\u8017\u65f6[" + sqlCost + "ms]\u7ed3\u679c\u96c6[" + size + "]");
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        log.info("set properties");
    }

    private String formatSql(String sql, Object parameterObject, List<ParameterMapping> parameterMappingList) {
        if (sql == "" || sql.length() == 0) {
            return "";
        }
        sql = this.beautifySql(sql);
        if (parameterObject == null || parameterMappingList == null || parameterMappingList.size() == 0) {
            return sql;
        }
        String sqlWithoutReplacePlaceholder = sql;
        try {
            if (parameterMappingList != null) {
                Class<?> parameterObjectClass = parameterObject.getClass();
                if (this.isStrictMap(parameterObjectClass)) {
                    DefaultSqlSession.StrictMap strictMap = (DefaultSqlSession.StrictMap)parameterObject;
                    if (this.isList(((Collection)strictMap.get((Object)"list")).getClass())) {
                        sql = this.handleListParameter(sql, (Collection)strictMap.get((Object)"list"));
                    }
                } else if (this.isMap(parameterObjectClass)) {
                    Map paramMap = (Map)parameterObject;
                    sql = this.handleMapParameter(sql, paramMap, parameterMappingList);
                } else {
                    sql = this.handleCommonParameter(sql, parameterMappingList, parameterObjectClass, parameterObject);
                }
            }
        }
        catch (Exception e) {
            return sqlWithoutReplacePlaceholder;
        }
        return sql;
    }

    private String handleCommonParameter(String sql, List<ParameterMapping> parameterMappingList, Class<?> parameterObjectClass, Object parameterObject) throws Exception {
        for (ParameterMapping parameterMapping : parameterMappingList) {
            String propertyValue = null;
            if (this.isPrimitiveOrPrimitiveWrapper(parameterObjectClass)) {
                propertyValue = parameterObject.toString();
            } else {
                String propertyName = parameterMapping.getProperty();
                Field field = parameterObjectClass.getDeclaredField(propertyName);
                field.setAccessible(true);
                propertyValue = String.valueOf(field.get(parameterObject));
                if (parameterMapping.getJavaType().isAssignableFrom(String.class)) {
                    propertyValue = "\"" + propertyValue + "\"";
                }
            }
            sql = sql.replaceFirst("\\?", propertyValue);
        }
        return sql;
    }

    private String handleMapParameter(String sql, Map<?, ?> paramMap, List<ParameterMapping> parameterMappingList) {
        for (ParameterMapping parameterMapping : parameterMappingList) {
            String propertyName = parameterMapping.getProperty();
            Object propertyValue = paramMap.get(propertyName);
            if (propertyValue == null) continue;
            if (propertyValue.getClass().isAssignableFrom(String.class)) {
                propertyValue = "\"" + propertyValue + "\"";
            }
            sql = sql.replaceFirst("\\?", propertyValue.toString());
        }
        return sql;
    }

    private String handleListParameter(String sql, Collection<?> col) {
        if (col != null && col.size() != 0) {
            for (Object obj : col) {
                String value = null;
                Class<String> objClass = obj.getClass();
                if (this.isPrimitiveOrPrimitiveWrapper(objClass)) {
                    value = obj.toString();
                } else if (objClass.isAssignableFrom(String.class)) {
                    value = "\"" + obj.toString() + "\"";
                }
                sql = sql.replaceFirst("\\?", value);
            }
        }
        return sql;
    }

    private String beautifySql(String sql) {
        sql = sql.replaceAll("[\\s\n ]+", " ");
        return sql;
    }

    private boolean isPrimitiveOrPrimitiveWrapper(Class<?> parameterObjectClass) {
        return parameterObjectClass.isPrimitive() || parameterObjectClass.isAssignableFrom(Byte.class) || parameterObjectClass.isAssignableFrom(Short.class) || parameterObjectClass.isAssignableFrom(Integer.class) || parameterObjectClass.isAssignableFrom(Long.class) || parameterObjectClass.isAssignableFrom(Double.class) || parameterObjectClass.isAssignableFrom(Float.class) || parameterObjectClass.isAssignableFrom(Character.class) || parameterObjectClass.isAssignableFrom(Boolean.class);
    }

    private boolean isStrictMap(Class<?> parameterObjectClass) {
        return parameterObjectClass.isAssignableFrom(DefaultSqlSession.StrictMap.class);
    }

    private boolean isList(Class<?> clazz) {
        Class<?>[] interfaceClasses;
        for (Class<List> clazz2 : interfaceClasses = clazz.getInterfaces()) {
            if (!clazz2.isAssignableFrom(List.class)) continue;
            return true;
        }
        return false;
    }

    private boolean isMap(Class<?> parameterObjectClass) {
        Class<?>[] interfaceClasses;
        for (Class<Map> clazz : interfaceClasses = parameterObjectClass.getInterfaces()) {
            if (!clazz.isAssignableFrom(Map.class)) continue;
            return true;
        }
        return false;
    }
}

