/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.mybatis;

import cn.dolphin.core.jdbc.JdbcDao;
import cn.dolphin.core.mybatis.IbatisSql;
import cn.dolphin.core.spring.SpringContextUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.mybatis.spring.SqlSessionTemplate;

public abstract class BaseMyBatisDao<T, ID extends Serializable>
extends JdbcDao<T, ID> {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    ThreadLocal<SqlSessionFactory> sqlSessionFactoryThreadLocal = new ThreadLocal();
    private static ThreadLocal<SqlSession> localSessions = new ThreadLocal();
    private SqlSessionFactory sqlSessionFactory;
    private SqlSessionTemplate sqlSessionTemplate;

    protected void checkDaoConfig() throws IllegalArgumentException {
    }

    public SqlSessionFactory getSqlSessionFactory() {
        if (this.sqlSessionFactory == null) {
            this.sqlSessionFactory = this.sqlSessionFactoryThreadLocal.get();
            if (this.sqlSessionFactory == null) {
                this.sqlSessionFactory = SpringContextUtil.getBean(SqlSessionFactory.class);
                this.setSqlSessionFactory(this.sqlSessionFactory);
                this.sqlSessionFactoryThreadLocal.set(this.sqlSessionFactory);
            }
        }
        return this.sqlSessionFactory;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
        this.sqlSessionTemplate = new SqlSessionTemplate(sqlSessionFactory);
    }

    public SqlSessionTemplate getSqlSessionTemplate() {
        if (this.sqlSessionFactory == null) {
            this.sqlSessionFactory = this.sqlSessionFactoryThreadLocal.get();
            if (this.sqlSessionFactory == null) {
                this.sqlSessionFactory = SpringContextUtil.getBean(SqlSessionFactory.class);
                this.setSqlSessionFactory(this.sqlSessionFactory);
                this.sqlSessionFactoryThreadLocal.set(this.sqlSessionFactory);
            }
        }
        return this.sqlSessionTemplate;
    }

    public SqlSession openSession() {
        SqlSession session = localSessions.get();
        if (session == null) {
            session = this.getSqlSessionFactory().openSession();
            localSessions.set(session);
        }
        return session;
    }

    public void close() {
        SqlSession session = localSessions.get();
        if (session != null) {
            session.close();
        }
        localSessions.remove();
    }

    public IbatisSql getIbatisSql(String id, Object parameterObject) {
        IbatisSql ibatisSql = new IbatisSql();
        Configuration configuration = this.getSqlSessionTemplate().getConfiguration();
        Collection coll = configuration.getMappedStatementNames();
        MappedStatement ms = configuration.getMappedStatement(id);
        BoundSql boundSql = ms.getBoundSql(parameterObject);
        TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
        List ResultMaps = ms.getResultMaps();
        if (ResultMaps != null && ResultMaps.size() > 0) {
            ResultMap ResultMap2 = (ResultMap)ms.getResultMaps().get(0);
            ibatisSql.setResultClass(ResultMap2.getType());
        }
        ibatisSql.setSql(boundSql.getSql());
        List parameterMappings = boundSql.getParameterMappings();
        if (parameterMappings != null) {
            Object[] parameterArray = new Object[parameterMappings.size()];
            MetaObject metaObject = parameterObject == null ? null : configuration.newMetaObject(parameterObject);
            for (int i = 0; i < parameterMappings.size(); ++i) {
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                String propertyName = parameterMapping.getProperty();
                Object value = boundSql.hasAdditionalParameter(propertyName) ? boundSql.getAdditionalParameter(propertyName) : (parameterObject == null ? null : (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass()) ? parameterObject : (metaObject == null ? null : metaObject.getValue(propertyName))));
                parameterArray[i] = value;
            }
            ibatisSql.setParameters(parameterArray);
        }
        return ibatisSql;
    }
}

