/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.msg;

import cn.dolphin.core.util.CollectionUtil;
import java.util.ArrayList;
import java.util.List;

public class ThreadMsgUtil {
    private static ThreadLocal<List<String>> localMsg = new ThreadLocal();

    public static void addMsg(String msg) {
        List<String> list = localMsg.get();
        if (CollectionUtil.isEmpty(list)) {
            list = new ArrayList<String>();
            localMsg.set(list);
        }
        list.add(msg);
    }

    public static List<String> getMsg() {
        return ThreadMsgUtil.getMsg(true);
    }

    public static List<String> getMsg(boolean clean) {
        List<String> list = localMsg.get();
        if (clean) {
            localMsg.remove();
        }
        return list;
    }

    public static String getMessage() {
        return ThreadMsgUtil.getMessage(true);
    }

    public static String getMessage(boolean clean) {
        return ThreadMsgUtil.getMessage(clean, "\r\n");
    }

    public static String getMessage(boolean clean, String lineBreak) {
        List<String> list = ThreadMsgUtil.getMsg(clean);
        if (CollectionUtil.isEmpty(list)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String msg : list) {
            sb.append(msg).append(lineBreak);
        }
        return sb.toString();
    }

    public static void clean() {
        localMsg.remove();
    }
}

