/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.mapper;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import ma.glasnost.orika.DefaultFieldMapper;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.impl.DefaultMapperFactory;
import ma.glasnost.orika.metadata.ClassMapBuilder;

public class MapperUtil {
    private static final MapperFactory MAPPER_FACTORY = new DefaultMapperFactory.Builder().build();

    public static <S, R> R mapperBean(S s, Class<R> rClass) {
        return (R)MAPPER_FACTORY.getMapperFacade().map(s, rClass);
    }

    public static <S, R> R mapperBean(S s, Class<R> rClass, Map<String, String> diffFieldMap) {
        ClassMapBuilder classMap = MAPPER_FACTORY.classMap(s.getClass(), rClass);
        diffFieldMap.forEach((arg_0, arg_1) -> ((ClassMapBuilder)classMap).field(arg_0, arg_1));
        classMap.byDefault(new DefaultFieldMapper[0]).register();
        return (R)MAPPER_FACTORY.getMapperFacade().map(s, rClass);
    }

    public static <S, R> List<R> mapperList(List<S> sList, Class<R> rClass) {
        return MAPPER_FACTORY.getMapperFacade().mapAsList(sList, rClass);
    }

    public static <S, R> List<R> mapperList(List<S> sList, Class<R> rClass, Map<String, String> diffFieldMap) {
        if (sList.isEmpty()) {
            return Collections.emptyList();
        }
        ClassMapBuilder classMap = MAPPER_FACTORY.classMap(sList.get(0).getClass(), rClass);
        diffFieldMap.forEach((arg_0, arg_1) -> ((ClassMapBuilder)classMap).field(arg_0, arg_1));
        classMap.byDefault(new DefaultFieldMapper[0]).register();
        return MAPPER_FACTORY.getMapperFacade().mapAsList(sList, rClass);
    }
}

