/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.map;

import java.util.HashMap;
import java.util.LinkedHashMap;

public class Maps {
    private static final int MAX_POWER_OF_TWO = 0x40000000;
    private static final int MIN = 3;

    private Maps() {
    }

    public static <K, V> HashMap<K, V> newHashMap(int expectedSize) {
        return new HashMap(Maps.capacity(expectedSize));
    }

    public static <K, V> HashMap<K, V> newLinkedHashMap(int expectedSize) {
        return new LinkedHashMap(Maps.capacity(expectedSize));
    }

    public static final int capacity(int expectedSize) {
        if (expectedSize < 0) {
            throw new IllegalArgumentException("Map\u521d\u59cb\u5316\u5927\u5c0f\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        if (expectedSize < 3) {
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return (int)((float)expectedSize / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }
}

