/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.map;

import cn.dolphin.core.map.MapKeyComparator;
import cn.dolphin.core.map.MapValueComparator;
import cn.dolphin.core.util.CastUtil;
import cn.dolphin.wechat.mp.model.message.WxMpTemplateData;
import com.google.common.collect.Maps;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapUtil {
    private static Logger logger = LoggerFactory.getLogger(MapUtil.class);
    private static final String OMIT_REG = "_";

    private MapUtil() {
    }

    public static <K, V> void putMultiValue(Map<K, List<V>> map, K k, V v) {
        if (map.get(k) == null) {
            ArrayList<V> values = new ArrayList<V>();
            values.add(v);
            map.put(k, values);
        } else {
            map.get(k).add(v);
        }
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return null != map && false == map.isEmpty();
    }

    public static boolean isContainsKey(Map<?, ?> map, String key) {
        return map.containsKey(key);
    }

    public static HashMap newHashMap(Object ... keyValues) {
        return (HashMap)MapUtil.newMap(HashMap.class, keyValues);
    }

    public static ConcurrentMap newConcurrentMap(Object ... keyValues) {
        return (ConcurrentMap)MapUtil.newMap(ConcurrentMap.class, keyValues);
    }

    public static TreeMap newTreeMap(Object ... keyValues) {
        return (TreeMap)MapUtil.newMap(TreeMap.class, keyValues);
    }

    public static LinkedHashMap newLinkedHashMap(Object ... keyValues) {
        return (LinkedHashMap)MapUtil.newMap(LinkedHashMap.class, keyValues);
    }

    public static IdentityHashMap newIdentityHashMap(Object ... keyValues) {
        return (IdentityHashMap)MapUtil.newMap(IdentityHashMap.class, keyValues);
    }

    public static String maptoString(Map<?, ?> map, char separator) {
        ArrayList result = new ArrayList();
        map.entrySet().parallelStream().reduce(result, (first, second) -> {
            first.add(second.getKey() + "=" + second.getValue());
            return first;
        }, (first, second) -> {
            if (first == second) {
                return first;
            }
            first.addAll(second);
            return first;
        });
        return StringUtils.join(result, (char)separator);
    }

    public static Map<String, String> maptoMapString(Map<String, ?> map) {
        return map.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> {
            if (null == entry.getValue()) {
                return "";
            }
            if (entry.getValue().getClass().isArray()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < Array.getLength(entry.getValue()); ++i) {
                    Object obj = Array.get(entry.getValue(), i);
                    sb.append(obj.toString()).append(",");
                }
                if (sb.length() > 0) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                return sb.toString();
            }
            return entry.getValue().toString();
        }));
    }

    public static <T> T getTParameter(Map<?, ?> params, String name, T defaultValue) {
        Object value = defaultValue;
        try {
            Object temp = params.get(name);
            if (temp != null) {
                value = temp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static <K, V> V getObject(Map<? super K, V> map, K key) {
        if (MapUtil.isNotEmpty(map)) {
            return map.get(key);
        }
        return null;
    }

    public static <K> String getString(Map<? super K, ?> map, K key) {
        Object answer;
        if (MapUtil.isNotEmpty(map) && (answer = map.get(key)) != null) {
            return CastUtil.castString(answer);
        }
        return null;
    }

    public static <K> Boolean getBoolean(Map<? super K, ?> map, K key) {
        Object answer;
        if (MapUtil.isNotEmpty(map) && (answer = map.get(key)) != null) {
            if (answer instanceof Boolean) {
                return (Boolean)answer;
            }
            if (answer instanceof String) {
                return Boolean.valueOf((String)answer);
            }
            if (answer instanceof Number) {
                Number n = (Number)answer;
                return n.intValue() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    public static <K> Number getNumber(Map<? super K, ?> map, K key) {
        Object answer;
        if (MapUtil.isNotEmpty(map) && (answer = map.get(key)) != null) {
            if (answer instanceof Number) {
                return (Number)answer;
            }
            if (answer instanceof String) {
                try {
                    String text = (String)answer;
                    return NumberFormat.getInstance().parse(text);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static <K> Byte getByte(Map<? super K, ?> map, K key) {
        Number answer = MapUtil.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Byte) {
            return (Byte)answer;
        }
        return answer.byteValue();
    }

    public static <K> Short getShort(Map<? super K, ?> map, K key) {
        Number answer = MapUtil.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Short) {
            return (Short)answer;
        }
        return answer.shortValue();
    }

    public static <K> Integer getInteger(Map<? super K, ?> map, K key) {
        Number answer = MapUtil.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Integer) {
            return (Integer)answer;
        }
        return answer.intValue();
    }

    public static <K> Long getLong(Map<? super K, ?> map, K key) {
        Number answer = MapUtil.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Long) {
            return (Long)answer;
        }
        return answer.longValue();
    }

    public static <K> Float getFloat(Map<? super K, ?> map, K key) {
        Number answer = MapUtil.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Float) {
            return (Float)answer;
        }
        return Float.valueOf(answer.floatValue());
    }

    public static <K> Double getDouble(Map<? super K, ?> map, K key) {
        Number answer = MapUtil.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Double) {
            return (Double)answer;
        }
        return answer.doubleValue();
    }

    public static <K> Map<?, ?> getMap(Map<? super K, ?> map, K key) {
        Object answer;
        if (MapUtil.isNotEmpty(map) && (answer = map.get(key)) != null && answer instanceof Map) {
            return (Map)answer;
        }
        return null;
    }

    public static <K, V> V getObject(Map<K, V> map, K key, V defaultValue) {
        V answer;
        if (MapUtil.isNotEmpty(map) && (answer = map.get(key)) != null) {
            return answer;
        }
        return defaultValue;
    }

    public static <K> String getString(Map<? super K, ?> map, K key, String defaultValue) {
        String answer = MapUtil.getString(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static <K> Boolean getBoolean(Map<? super K, ?> map, K key, Boolean defaultValue) {
        Boolean answer = MapUtil.getBoolean(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static <K> Number getNumber(Map<? super K, ?> map, K key, Number defaultValue) {
        Number answer = MapUtil.getNumber(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static <K> Byte getByte(Map<? super K, ?> map, K key, Byte defaultValue) {
        Byte answer = MapUtil.getByte(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static <K> Short getShort(Map<? super K, ?> map, K key, Short defaultValue) {
        Short answer = MapUtil.getShort(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static <K> Integer getInteger(Map<? super K, ?> map, K key, Integer defaultValue) {
        Integer answer = MapUtil.getInteger(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static <K> Long getLong(Map<? super K, ?> map, K key, Long defaultValue) {
        Long answer = MapUtil.getLong(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static <K> Float getFloat(Map<? super K, ?> map, K key, Float defaultValue) {
        Float answer = MapUtil.getFloat(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static <K> Double getDouble(Map<? super K, ?> map, K key, Double defaultValue) {
        Double answer = MapUtil.getDouble(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static <K> Map<?, ?> getMap(Map<? super K, ?> map, K key, Map<?, ?> defaultValue) {
        Map<?, ?> answer = MapUtil.getMap(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Map requestParameterMapToMap(Map requestParams) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
            }
            resultMap.put(name, valueStr);
        }
        return resultMap;
    }

    public static String getOrderedQueryStr(Map<String, Object> map, boolean isSort, Set<String> removeKey) {
        StringBuffer param = new StringBuffer();
        ArrayList<String> msgList = new ArrayList<String>();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (removeKey != null && removeKey.contains(key)) continue;
            msgList.add(key + "=" + value);
        }
        if (isSort) {
            Collections.sort(msgList);
        }
        for (int i = 0; i < msgList.size(); ++i) {
            String msg = (String)msgList.get(i);
            if (i > 0) {
                param.append("&");
            }
            param.append(msg);
        }
        return param.toString();
    }

    public static <E> List<E> toBeanList(Class<E> cla, List<Map<String, Object>> mapList) {
        ArrayList<E> list = new ArrayList<E>(mapList.size());
        for (Map<String, Object> map : mapList) {
            E obj = MapUtil.toBean(cla, map);
            list.add(obj);
        }
        return list;
    }

    public static <E> E toBean(Class<E> cla, Map<String, Object> map) {
        Method[] ms;
        E obj = null;
        try {
            obj = cla.newInstance();
            if (obj == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            logger.error("\u7c7b\u578b\u5b9e\u4f8b\u5316\u5bf9\u8c61\u5931\u8d25,\u7c7b\u578b:" + cla);
            return null;
        }
        HashMap<String, Object> newmap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> en : map.entrySet()) {
            newmap.put("set" + en.getKey().trim().replaceAll(OMIT_REG, "").toLowerCase(), en.getValue());
        }
        for (Method method : ms = cla.getMethods()) {
            String mname = method.getName().toLowerCase();
            if (!mname.startsWith("set")) continue;
            Class<?>[] clas = method.getParameterTypes();
            Object v = newmap.get(mname);
            if (v == null || clas.length != 1) continue;
            try {
                method.invoke(obj, v);
            }
            catch (Exception e) {
                logger.error("\u5c5e\u6027\u503c\u88c5\u5165\u5931\u8d25,\u88c5\u5165\u65b9\u6cd5\uff1a" + cla + "." + method.getName() + ".\u53ef\u88c5\u5165\u7c7b\u578b" + clas[0] + ";\u6b32\u88c5\u5165\u503c\u7684\u7c7b\u578b:" + v.getClass());
            }
        }
        return obj;
    }

    public static Map convertBeanToMap(Object bean) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Class<?> type = bean.getClass();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        BeanInfo beanInfo = Introspector.getBeanInfo(type);
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            String propertyName = descriptor.getName();
            if (propertyName.equals("class")) continue;
            Method readMethod = descriptor.getReadMethod();
            Object result = readMethod.invoke(bean, new Object[0]);
            if (result != null) {
                returnMap.put(propertyName, result);
                continue;
            }
            returnMap.put(propertyName, "");
        }
        return returnMap;
    }

    public static Map<String, Object> convertDataMap(HttpServletRequest request) {
        Map properties = request.getParameterMap();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        Iterator entries = properties.entrySet().iterator();
        String name = "";
        String value = "";
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            name = (String)entry.getKey();
            Object valueObj = entry.getValue();
            if (null == valueObj) {
                value = "";
            } else if (valueObj instanceof String[]) {
                String[] values = (String[])valueObj;
                for (int i = 0; i < values.length; ++i) {
                    value = values[i] + ",";
                }
                value = value.substring(0, value.length() - 1);
            } else {
                value = valueObj.toString();
            }
            returnMap.put(name, value);
        }
        return returnMap;
    }

    public static Object convertMapToBean(Class type, Map map) throws IntrospectionException, IllegalAccessException, InstantiationException, InvocationTargetException {
        BeanInfo beanInfo = Introspector.getBeanInfo(type);
        Object obj = type.newInstance();
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            String propertyName = descriptor.getName();
            if (!map.containsKey(propertyName)) continue;
            Object value = map.get(propertyName);
            Object[] args = new Object[]{value};
            descriptor.getWriteMethod().invoke(obj, args);
        }
        return obj;
    }

    public static void mapToObject(Map<String, Object> map, String classPath, Object obj) {
        try {
            Class<?> clazz = Class.forName(obj.getClass().getName());
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                String varName = fields[i].getName();
                Object value = map.get(varName);
                if (null == value) continue;
                Method method = clazz.getMethod("set" + varName.toUpperCase().charAt(0) + varName.subSequence(1, varName.length()), String.class);
                method.invoke(obj, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static <R extends Map> R newMap(Class<? extends Map> type, Object ... keyValues) {
        Map resultMap;
        if (null == keyValues) {
            logger.warn("MapUtil#newMap() keyValues is null.");
            return null;
        }
        int length = keyValues.length;
        if (length % 2 != 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u7b26\u5408\u9884\u671f, \u53ef\u53d8\u6570\u7ec4\u5e94\u8be5\u6210\u5bf9\u51fa\u73b0\u3002");
        }
        if (type == HashMap.class) {
            resultMap = Maps.newHashMap();
        } else if (type == ConcurrentMap.class) {
            resultMap = Maps.newConcurrentMap();
        } else if (type == TreeMap.class) {
            resultMap = Maps.newTreeMap();
        } else if (type == LinkedHashMap.class) {
            resultMap = Maps.newLinkedHashMap();
        } else if (type == IdentityHashMap.class) {
            resultMap = Maps.newIdentityHashMap();
        } else {
            throw new IllegalArgumentException("MapUtil#newMap() type = " + type.getSimpleName() + " \u4e0d\u652f\u6301\u3002");
        }
        for (int i = 0; i < length; i += 2) {
            resultMap.put(keyValues[i], keyValues[i + 1]);
        }
        return (R)resultMap;
    }

    public static Map<String, String> sortMapByKey(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        TreeMap<String, String> sortMap = new TreeMap<String, String>(new MapKeyComparator());
        sortMap.putAll(map);
        return sortMap;
    }

    public static Map<String, String> sortAsc(Map<String, String> map) {
        LinkedHashMap<String, String> tempMap = new LinkedHashMap<String, String>();
        ArrayList<Map.Entry<String, String>> infoIds = new ArrayList<Map.Entry<String, String>>(map.entrySet());
        Collections.sort(infoIds, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        for (int i = 0; i < infoIds.size(); ++i) {
            Map.Entry item = (Map.Entry)infoIds.get(i);
            tempMap.put((String)item.getKey(), (String)item.getValue());
        }
        return tempMap;
    }

    public static Map<String, String> sortMapByValue(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> sortedMap = new LinkedHashMap<String, String>();
        ArrayList<Map.Entry<String, String>> entryList = new ArrayList<Map.Entry<String, String>>(map.entrySet());
        Collections.sort(entryList, new MapValueComparator());
        Iterator iter = entryList.iterator();
        Map.Entry tmpEntry = null;
        while (iter.hasNext()) {
            tmpEntry = (Map.Entry)iter.next();
            sortedMap.put((String)tmpEntry.getKey(), (String)tmpEntry.getValue());
        }
        return sortedMap;
    }

    public static String mapJoin(Map<String, String> map, boolean valueUrlEncode) {
        StringBuilder sb = new StringBuilder();
        for (String key : map.keySet()) {
            if (map.get(key) == null || "".equals(map.get(key))) continue;
            try {
                String temp = key.endsWith(OMIT_REG) && key.length() > 1 ? key.substring(0, key.length() - 1) : key;
                sb.append(temp);
                sb.append("=");
                String value = map.get(key);
                if (valueUrlEncode) {
                    value = URLEncoder.encode(map.get(key), "utf-8").replace("+", "%20");
                }
                sb.append(value);
                sb.append("&");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(MapUtil.newHashMap("key1", new WxMpTemplateData(), "key2", new WxMpTemplateData()));
    }
}

