/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.json;

import cn.dolphin.core.exception.JsonParseException;
import cn.dolphin.core.map.MapUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class JacksonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private JacksonUtils() {
    }

    public static ObjectMapper getInstance() {
        return OBJECT_MAPPER;
    }

    public static String obj2json(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new JsonParseException();
        }
    }

    public static <T> T json2obj(String jsonStr, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(jsonStr, clazz);
        }
        catch (IOException e) {
            throw new JsonParseException();
        }
    }

    public static <T> T json2obj(String jsonStr, JavaType javaType) {
        try {
            return (T)OBJECT_MAPPER.readValue(jsonStr, javaType);
        }
        catch (IOException e) {
            throw new JsonParseException();
        }
    }

    public static Map<String, Object> json2map(String jsonStr) {
        try {
            return (Map)OBJECT_MAPPER.readValue(jsonStr, Map.class);
        }
        catch (IOException e) {
            throw new JsonParseException();
        }
    }

    public static <T> Map<String, T> json2map(String jsonStr, Class<T> clazz) {
        Map map;
        try {
            map = (Map)OBJECT_MAPPER.readValue(jsonStr, new TypeReference<Map<String, T>>(){});
        }
        catch (IOException e) {
            throw new JsonParseException();
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            result.put(entry.getKey(), JacksonUtils.map2obj((Map)entry.getValue(), clazz));
        }
        return result;
    }

    public static <T> List<T> json2list(String jsonArrayStr, Class<T> clazz) {
        List list = null;
        try {
            list = (List)OBJECT_MAPPER.readValue(jsonArrayStr, new TypeReference<List<T>>(){});
        }
        catch (IOException e) {
            throw new JsonParseException();
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Map map : list) {
            result.add(JacksonUtils.map2obj(map, clazz));
        }
        return result;
    }

    public static <T> T map2obj(Map map, Class<T> clazz) {
        return (T)OBJECT_MAPPER.convertValue((Object)map, clazz);
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Integer> testMap = new HashMap<String, Integer>();
        testMap.put("a", null);
        testMap.put("b", 11);
        String s = JacksonUtils.obj2json(testMap);
        System.out.println(s);
        System.out.println(MapUtil.maptoMapString(testMap));
    }

    static {
        OBJECT_MAPPER.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }
}

