/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GsonUtil {
    private static Gson gson = null;

    public static String objectToJson(Object ts) {
        String jsonStr = null;
        if (gson != null) {
            jsonStr = gson.toJson(ts);
        }
        return jsonStr;
    }

    public static String StringJoin(Collection<?> collection, String separator) {
        Joiner joiner = Joiner.on((String)separator).skipNulls();
        return joiner.join(collection);
    }

    public static List<String> separatorString(String source, String separator) {
        Splitter splitter = Splitter.on((String)separator).trimResults().omitEmptyStrings();
        return splitter.splitToList((CharSequence)source);
    }

    public static String objectToJsonDateSerializer(Object ts, final String dateformat) {
        String jsonStr = null;
        gson = new GsonBuilder().registerTypeHierarchyAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                SimpleDateFormat format = new SimpleDateFormat(dateformat);
                return new JsonPrimitive(format.format(src));
            }
        }).setDateFormat(dateformat).create();
        if (gson != null) {
            jsonStr = gson.toJson(ts);
        }
        return jsonStr;
    }

    public static List<?> jsonToList(String jsonStr) {
        List objList = null;
        if (gson != null) {
            Type type = new TypeToken<List<?>>(){}.getType();
            objList = (List)gson.fromJson(jsonStr, type);
        }
        return objList;
    }

    public static <T> List<T> jsonToList(String jsonStr, Class<T> T) {
        List objList = null;
        if (gson != null) {
            Type type = new TypeToken<List<T>>(){}.getType();
            objList = (List)gson.fromJson(jsonStr, type);
        }
        return objList;
    }

    public static <T> List<T> stringToArray(String s, Class<T[]> clazz) {
        Object[] arr = (Object[])new Gson().fromJson(s, clazz);
        return Arrays.asList(arr);
    }

    public static List<Map<String, String>> jsonToListStr(String jsonStr) {
        List objList = null;
        if (gson != null) {
            Type type = new TypeToken<List<Map<String, String>>>(){}.getType();
            objList = (List)gson.fromJson(jsonStr, type);
        }
        return objList;
    }

    public static Object jsonToBean(String jsonStr, Class<?> cl) {
        Object obj = null;
        if (gson != null) {
            obj = gson.fromJson(jsonStr, cl);
        }
        return obj;
    }

    public static <T> T jsonToBeanDateSerializer(String jsonStr, Class<T> cl, final String pattern) {
        Object obj = null;
        gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                SimpleDateFormat format = new SimpleDateFormat(pattern);
                String dateStr = json.getAsString();
                try {
                    return format.parse(dateStr);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }).setDateFormat(pattern).create();
        if (gson != null) {
            obj = gson.fromJson(jsonStr, cl);
        }
        return (T)obj;
    }

    public static Object getJsonValue(String jsonStr, String key) {
        Object resultObj = null;
        Map<?, ?> resultMap = GsonUtil.jsonToMap(jsonStr);
        if (null != resultMap && !resultMap.isEmpty() && resultMap.containsKey(key)) {
            resultObj = resultMap.get(key);
        }
        return resultObj;
    }

    public static Map<?, ?> jsonToMap(String jsonStr) {
        Map objectMap = null;
        if (null != gson) {
            Type type = new TypeToken<Map<?, ?>>(){}.getType();
            objectMap = (Map)gson.fromJson(jsonStr, type);
        }
        return objectMap;
    }

    public static <T> Map<String, T> jsonToMap(String json, Class<T> clz) {
        Map map = (Map)gson.fromJson(json, new com.google.common.reflect.TypeToken<Map<String, JsonObject>>(){}.getType());
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : map.keySet()) {
            result.put(key, gson.fromJson((JsonElement)map.get(key), clz));
        }
        return result;
    }

    public static <T> T fromJsonString(String json, Class<T> classOfT) {
        Object t = null;
        if (gson != null) {
            t = gson.fromJson(json, classOfT);
        }
        return (T)t;
    }

    public static String fromJsonString(String json, String key) {
        String value;
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode root = mapper.readTree(json);
            JsonNode data = root.path(key);
            value = data.asText();
        }
        catch (IOException e) {
            value = null;
        }
        return value;
    }

    public static <T> List<T> toList(String json, Class<T> cls) {
        List list = null;
        if (gson != null) {
            list = (List)gson.fromJson(json, new com.google.common.reflect.TypeToken<List<T>>(){}.getType());
        }
        return list;
    }

    public static <T> List<Map<String, T>> toListMaps(String json) {
        List list = null;
        if (gson != null) {
            list = (List)gson.fromJson(json, new com.google.common.reflect.TypeToken<List<Map<String, T>>>(){}.getType());
        }
        return list;
    }

    static {
        if (gson == null) {
            gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
        }
    }
}

