/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.json;

import cn.dolphin.core.json.JsonMapper;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.io.IOException;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastJsonUtil {
    private static final Logger log = LoggerFactory.getLogger(FastJsonUtil.class);
    private static ObjectMapper objectMapper = null;
    public static final SerializerFeature[] FEATURES;
    public static final SerializerFeature[] PRETTY_FEATURES;

    public static boolean isJsonObjectString(String str) {
        return str != null && str.matches("^\\{.*\\}$");
    }

    public static boolean isJsonArrayString(String str) {
        return str != null && str.matches("^\\[.*\\]$");
    }

    public static final String toString(Object obj) {
        return JSON.toJSONString((Object)obj, (SerializerFeature[])FEATURES);
    }

    public static final String toString2(Object obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            log.error("write to json string error:" + obj, (Throwable)e);
            return null;
        }
    }

    public static final String toString(Object obj, String dateFormat) {
        return JSON.toJSONStringWithDateFormat((Object)obj, (String)dateFormat, (SerializerFeature[])FEATURES);
    }

    public static final String toFormatString(Object obj) {
        return JSON.toJSONString((Object)obj, (SerializerFeature[])PRETTY_FEATURES);
    }

    public static final JSONObject parseObject(String json) {
        return JSON.parseObject((String)json);
    }

    public static final JSONArray parseArray(String json) {
        return JSON.parseArray((String)json);
    }

    public static final <T> T parse(String json, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        return (T)JSON.parseObject((String)json, clazz);
    }

    public static final <T> List<T> parseList(String json, Class<T> clazz) {
        return JSON.parseArray((String)json, clazz);
    }

    public static final <T> T parse(JSONObject obj, Class<T> clazz) {
        if (obj == null) {
            return null;
        }
        return (T)JSON.toJavaObject((JSON)obj, clazz);
    }

    public static final <T> T[] parseArray(JSONArray array, T[] t) {
        return array.toArray((Object[])t);
    }

    public static final <T> T[] parseArray(String json, T[] arr) {
        return JSON.parseArray((String)json).toArray((Object[])arr);
    }

    public static final <T> List<T> parseList(JSONArray array, Class<T> clazz) {
        if (array == null) {
            return null;
        }
        return array.toJavaList(clazz);
    }

    public void setTimeZone(TimeZone tz) {
        objectMapper.setTimeZone(tz);
    }

    public static String toJson(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            String json = objectMapper.writeValueAsString(obj);
            return json;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Jackson\u8f6c\u5b57\u7b26\u4e32\u51fa\u73b0\u5f02\u5e38\uff1a", e);
        }
    }

    public static JsonNode toJsonNode(Object obj) {
        if (obj instanceof String) {
            try {
                return objectMapper.readTree((String)obj);
            }
            catch (Exception e) {
                throw new RuntimeException("Java\u5bf9\u8c61\u8f6c\u6210JsonNode\u51fa\u73b0\u5f02\u5e38\uff1a", e);
            }
        }
        return objectMapper.valueToTree(obj);
    }

    public static String toJson(Object obj, boolean toPrettify) {
        return JSON.toJSONString((Object)obj, (boolean)toPrettify);
    }

    public static <T> T toObject(String json, Class<T> type) {
        if (json == null || "".equals(json.trim())) {
            return null;
        }
        try {
            Object value = objectMapper.readValue(json, type);
            return (T)value;
        }
        catch (Exception e) {
            throw new RuntimeException("Jackson\u8f6cJava\u5bf9\u8c61\u51fa\u73b0\u5f02\u5e38\uff1a", e);
        }
    }

    public static <E> List<E> toList(Object obj, Class<E> clazz) {
        return (List)FastJsonUtil.toGeneric(obj, List.class, clazz);
    }

    public static Object toGeneric(Object obj, Class<?> parametrized, Class ... parameterClasses) {
        JavaType type = objectMapper.getTypeFactory().constructParametricType(parametrized, parameterClasses);
        return FastJsonUtil.toGeneric(obj, type);
    }

    public static <E> Set<E> toSet(Object obj, Class<E> clazz) {
        return (Set)FastJsonUtil.toGeneric(obj, Set.class, clazz);
    }

    public static <K, V> Map<K, V> toMap(Object obj, Class<K> keyClazz, Class<V> valueClazz) {
        return (Map)FastJsonUtil.toGeneric(obj, Map.class, keyClazz, valueClazz);
    }

    public static Map toMap(Object obj) {
        return (Map)JSON.parseObject((String)JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty}), Map.class);
    }

    public static JSONObject toJSONObject(String json) {
        return JSONObject.parseObject((String)json);
    }

    public static JSONObject toJSONObject(Object obj) {
        return FastJsonUtil.toJSONObject(obj);
    }

    public static JSONArray toJSONArray(String json) {
        return JSONObject.parseArray((String)json);
    }

    @Deprecated
    public static Map toMap(String json) {
        return (Map)JSON.parseObject((String)json, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
    }

    public static <E> E toObject(Object obj, Class<E> clazz) {
        try {
            if (obj instanceof String) {
                if (clazz == String.class) {
                    return (E)obj;
                }
                return (E)objectMapper.readValue((String)obj, clazz);
            }
            if (obj instanceof JsonNode) {
                return (E)objectMapper.readValue(obj.toString(), clazz);
            }
            return (E)objectMapper.readValue(objectMapper.writeValueAsString(obj), clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonNode path(JsonNode jsonNode, String pathStr) {
        String[] splitPaths = pathStr.split("\\.");
        if ((jsonNode = jsonNode.path(splitPaths[0])) instanceof MissingNode) {
            return null;
        }
        if (splitPaths.length == 1) {
            return jsonNode;
        }
        return FastJsonUtil.path(jsonNode, pathStr.substring(pathStr.indexOf(".") + 1));
    }

    private static Object toGeneric(Object obj, JavaType type) {
        try {
            if (obj instanceof String) {
                return objectMapper.readValue((String)obj, type);
            }
            if (obj instanceof JsonNode) {
                return objectMapper.readValue(obj.toString(), type);
            }
            return objectMapper.readValue(objectMapper.writeValueAsString(obj), type);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String writeValue(Object object) {
        StringWriter result = new StringWriter();
        try {
            JsonMapper mapper = new JsonMapper();
            mapper.writeValue(result, object);
        }
        catch (Exception e) {
            log.error("write json value error:" + e.getMessage());
        }
        return result.toString().length() != 0 ? result.toString() : "{}";
    }

    public static <T> T readValue(String json, Class<T> clazz) {
        Object result = null;
        try {
            if (json != null) {
                JsonMapper mapper = new JsonMapper();
                result = mapper.readValue(json, clazz);
            }
        }
        catch (Exception e) {
            log.error("read json value error:" + e.getMessage());
        }
        return (T)result;
    }

    static {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            objectMapper.setTimeZone(TimeZone.getTimeZone(ZoneId.systemDefault()));
            objectMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
            objectMapper.getSerializerProvider().setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

                public void serialize(Object arg0, JsonGenerator arg1, SerializerProvider arg2) throws IOException, JsonProcessingException {
                    arg1.writeString("");
                }
            });
            objectMapper.getDeserializationConfig().withoutFeatures(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
            objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
            objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            JavaTimeModule javaTimeModule = new JavaTimeModule();
            javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
            javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
            objectMapper.registerModule((Module)javaTimeModule);
        }
        FEATURES = new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat};
        PRETTY_FEATURES = new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.PrettyFormat};
    }
}

