/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.jdbc.util;

import java.util.Calendar;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class StringRegularOpt {
    private StringRegularOpt() {
        throw new IllegalAccessError("Utility class");
    }

    public static String trimString(String szWord) {
        if (szWord == null) {
            return "";
        }
        String strWord = szWord.trim();
        int sl = strWord.length();
        if (sl >= 2 && (strWord.charAt(0) == '\"' && strWord.charAt(sl - 1) == '\"' || strWord.charAt(0) == '\'' && strWord.charAt(sl - 1) == '\'')) {
            strWord = sl > 2 ? strWord.substring(1, sl - 1) : "";
        }
        return strWord;
    }

    public static String trimStringQuoted(String szWord) {
        return StringRegularOpt.trimString(szWord);
    }

    public static String quotedString(String szWord) {
        if (szWord == null) {
            return "\"\"";
        }
        return "\"" + StringUtils.replace((String)szWord.trim(), (String)"\"", (String)"'") + "\"";
    }

    public static boolean isDoubleByteChar(char letter) {
        return letter / 128 != 0;
    }

    public static boolean isDigit(String pszNum) {
        return StringUtils.isNumeric((CharSequence)pszNum);
    }

    public static boolean isNumber(String pszNum) {
        int sp;
        String szNum = StringRegularOpt.trimString(pszNum);
        int sl = szNum.length();
        if (sl < 1) {
            return false;
        }
        for (sp = 0; sp < sl && (szNum.charAt(sp) == ' ' || szNum.charAt(sp) == '\t'); ++sp) {
        }
        if (sp < sl && (szNum.charAt(sp) == '-' || szNum.charAt(sp) == '+')) {
            ++sp;
        }
        if (sp == sl || sp + 1 == sl && szNum.charAt(sp) == '.') {
            return false;
        }
        while (sp < sl) {
            if (szNum.charAt(sp) >= '0' && szNum.charAt(sp) <= '9') {
                ++sp;
                continue;
            }
            if (szNum.charAt(sp) == '.') {
                ++sp;
                break;
            }
            return false;
        }
        while (sp < sl) {
            if (szNum.charAt(sp) >= '0' && szNum.charAt(sp) <= '9') {
                ++sp;
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean isString(String szWord) {
        if (szWord == null) {
            return false;
        }
        String strWord = szWord.trim();
        int sl = strWord.length();
        return sl >= 2 && (strWord.charAt(0) == '\"' && strWord.charAt(sl - 1) == '\"' || strWord.charAt(0) == '\'' && strWord.charAt(sl - 1) == '\'');
    }

    public static boolean isNvl(String str) {
        return str == null || "".equals(str.trim());
    }

    public static boolean isTrue(String str) {
        if (str == "true") {
            return true;
        }
        if (str == null) {
            return false;
        }
        switch (str.length()) {
            case 1: {
                char ch0 = str.charAt(0);
                if (ch0 != 'y' && ch0 != 'Y' && ch0 != 't' && ch0 != 'T' && ch0 != '1') break;
                return true;
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                if (ch0 != 'o' && ch0 != 'O' || ch1 != 'n' && ch1 != 'N') break;
                return true;
            }
            case 3: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char ch2 = str.charAt(2);
                if (ch0 != 'y' && ch0 != 'Y' || ch1 != 'e' && ch1 != 'E' || ch2 != 's' && ch2 != 'S') break;
                return true;
            }
            case 4: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char ch2 = str.charAt(2);
                char ch3 = str.charAt(3);
                if (ch0 != 't' && ch0 != 'T' || ch1 != 'r' && ch1 != 'R' || ch2 != 'u' && ch2 != 'U' || ch3 != 'e' && ch3 != 'E') break;
                return true;
            }
        }
        if (!StringRegularOpt.isNumber(str)) {
            return false;
        }
        long bRes = Math.round(Double.valueOf(str));
        return bRes != 0L;
    }

    public static boolean isFalse(String str) {
        if (str == "false") {
            return true;
        }
        if (str == null) {
            return false;
        }
        switch (str.length()) {
            case 1: {
                char ch0 = str.charAt(0);
                if (ch0 != 'n' && ch0 != 'N' && ch0 != 'f' && ch0 != 'F' && ch0 != '0') break;
                return true;
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                if (ch0 != 'n' && ch0 != 'N' || ch1 != 'o' && ch1 != 'O') break;
                return true;
            }
            case 3: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char ch2 = str.charAt(2);
                if (ch0 != 'o' && ch0 != 'O' || ch1 != 'f' && ch1 != 'F' || ch2 != 'f' && ch2 != 'F') break;
                return true;
            }
            case 5: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char ch2 = str.charAt(2);
                char ch3 = str.charAt(3);
                char ch4 = str.charAt(4);
                if (ch0 != 'f' && ch0 != 'F' || ch1 != 'a' && ch1 != 'A' || ch2 != 'l' && ch2 != 'L' || ch3 != 's' && ch3 != 'S' || ch4 != 'e' && ch4 != 'E') break;
                return true;
            }
        }
        if (!StringRegularOpt.isNumber(str)) {
            return false;
        }
        long bRes = Math.round(Double.valueOf(str));
        return bRes == 0L;
    }

    public static boolean isDatetime(String szTime, Calendar t_time) {
        int y;
        int sp;
        if (szTime == null) {
            return false;
        }
        int sl = szTime.length();
        int s = 0;
        String c = "";
        for (sp = 0; sp < sl && (szTime.charAt(sp) < '0' || szTime.charAt(sp) > '9'); ++sp) {
        }
        while (sp < sl) {
            if (szTime.charAt(sp) >= '0' && szTime.charAt(sp) <= '9') {
                if (s < 4) {
                    c = c + szTime.charAt(sp);
                }
                ++sp;
                ++s;
                continue;
            }
            ++sp;
            break;
        }
        if ((y = Integer.valueOf(c).intValue()) < 1970 || y > 2038) {
            return false;
        }
        while (sp < sl && (szTime.charAt(sp) < '0' || szTime.charAt(sp) > '9')) {
            ++sp;
        }
        s = 0;
        c = "";
        while (sp < sl) {
            if (szTime.charAt(sp) >= '0' && szTime.charAt(sp) <= '9') {
                if (s < 2) {
                    c = c + szTime.charAt(sp);
                }
                ++sp;
                ++s;
                continue;
            }
            ++sp;
            break;
        }
        if (s > 2) {
            return false;
        }
        int m = Integer.valueOf(c);
        if (m < 1 || m > 12) {
            return false;
        }
        while (sp < sl && (szTime.charAt(sp) < '0' || szTime.charAt(sp) > '9')) {
            ++sp;
        }
        s = 0;
        c = "";
        while (sp < sl) {
            if (szTime.charAt(sp) >= '0' && szTime.charAt(sp) <= '9') {
                if (s < 2) {
                    c = c + szTime.charAt(sp);
                }
                ++sp;
                ++s;
                continue;
            }
            ++sp;
            break;
        }
        if (s > 2) {
            return false;
        }
        int d = Integer.valueOf(c);
        if (d < 1 || d > 31) {
            return false;
        }
        while (sp < sl && (szTime.charAt(sp) < '0' || szTime.charAt(sp) > '9')) {
            ++sp;
        }
        s = 0;
        c = "";
        while (sp < sl) {
            if (szTime.charAt(sp) >= '0' && szTime.charAt(sp) <= '9') {
                if (s < 2) {
                    c = c + szTime.charAt(sp);
                }
                ++sp;
                ++s;
                continue;
            }
            ++sp;
            break;
        }
        if (s > 2) {
            return false;
        }
        int h = Integer.valueOf(c);
        if (h < 0 || h > 24) {
            return false;
        }
        while (sp < sl && (szTime.charAt(sp) < '0' || szTime.charAt(sp) > '9')) {
            ++sp;
        }
        s = 0;
        c = "";
        while (sp < sl) {
            if (szTime.charAt(sp) >= '0' && szTime.charAt(sp) <= '9') {
                if (s < 2) {
                    c = c + szTime.charAt(sp);
                }
                ++sp;
                ++s;
                continue;
            }
            ++sp;
            break;
        }
        if (s > 2) {
            return false;
        }
        int min = Integer.valueOf(c);
        if (min < 0 || min > 60) {
            return false;
        }
        s = 0;
        c = "";
        while (sp < sl && (szTime.charAt(sp) < '0' || szTime.charAt(sp) > '9')) {
            ++sp;
        }
        while (sp < sl && szTime.charAt(sp) >= '0' && szTime.charAt(sp) <= '9') {
            if (s < 2) {
                c = c + szTime.charAt(sp);
            }
            ++sp;
            ++s;
        }
        if (s > 2) {
            return false;
        }
        int sec = Integer.valueOf(c);
        if (sec < 0 || sec > 60) {
            return false;
        }
        t_time.set(y, m, d, h, min, sec);
        return true;
    }

    public static boolean isDatetime(String szTime) {
        Calendar t_time = Calendar.getInstance();
        boolean b = StringRegularOpt.isDatetime(szTime, t_time);
        return b;
    }

    public static boolean isDate(String szTime, Calendar t_time) {
        int y;
        int sp;
        if (szTime == null) {
            return false;
        }
        int sl = szTime.length();
        int s = 0;
        String c = "";
        for (sp = 0; sp < sl && (szTime.charAt(sp) < '0' || szTime.charAt(sp) > '9'); ++sp) {
        }
        while (sp < sl) {
            if (szTime.charAt(sp) >= '0' && szTime.charAt(sp) <= '9') {
                if (s < 4) {
                    c = c + szTime.charAt(sp);
                }
                ++sp;
                ++s;
                continue;
            }
            ++sp;
            break;
        }
        if ((y = Integer.valueOf(c).intValue()) < 1970 || y > 2038) {
            return false;
        }
        while (sp < sl && (szTime.charAt(sp) < '0' || szTime.charAt(sp) > '9')) {
            ++sp;
        }
        s = 0;
        c = "";
        while (sp < sl) {
            if (szTime.charAt(sp) >= '0' && szTime.charAt(sp) <= '9') {
                if (s < 2) {
                    c = c + szTime.charAt(sp);
                }
                ++sp;
                ++s;
                continue;
            }
            ++sp;
            break;
        }
        if (s > 2) {
            return false;
        }
        int m = Integer.valueOf(c);
        if (m < 1 || m > 12) {
            return false;
        }
        while (sp < sl && (szTime.charAt(sp) < '0' || szTime.charAt(sp) > '9')) {
            ++sp;
        }
        s = 0;
        c = "";
        while (sp < sl) {
            if (szTime.charAt(sp) >= '0' && szTime.charAt(sp) <= '9') {
                if (s < 2) {
                    c = c + szTime.charAt(sp);
                }
                ++sp;
                ++s;
                continue;
            }
            ++sp;
            break;
        }
        if (s > 2) {
            return false;
        }
        int d = Integer.valueOf(c);
        if (d < 1 || d > 31) {
            return false;
        }
        t_time.set(y, m, d, 0, 0, 0);
        return true;
    }

    public static boolean isDate(String szTime) {
        Calendar t_time = Calendar.getInstance();
        boolean b = StringRegularOpt.isDate(szTime, t_time);
        return b;
    }

    public static boolean isTime(String szTime, Calendar t_time) {
        int sp;
        if (szTime == null) {
            return false;
        }
        int sl = szTime.length();
        int s = 0;
        String c = "";
        for (sp = 0; sp < sl && (szTime.charAt(sp) < '0' || szTime.charAt(sp) > '9'); ++sp) {
        }
        s = 0;
        c = "";
        while (sp < sl) {
            if (szTime.charAt(sp) >= '0' && szTime.charAt(sp) <= '9') {
                if (s < 2) {
                    c = c + szTime.charAt(sp);
                }
                ++sp;
                ++s;
                continue;
            }
            ++sp;
            break;
        }
        if (s > 2) {
            return false;
        }
        int h = Integer.valueOf(c);
        if (h < 0 || h > 24) {
            return false;
        }
        while (sp < sl && (szTime.charAt(sp) < '0' || szTime.charAt(sp) > '9')) {
            ++sp;
        }
        s = 0;
        c = "";
        while (sp < sl) {
            if (szTime.charAt(sp) >= '0' && szTime.charAt(sp) <= '9') {
                if (s < 2) {
                    c = c + szTime.charAt(sp);
                }
                ++sp;
                ++s;
                continue;
            }
            ++sp;
            break;
        }
        if (s > 2) {
            return false;
        }
        int min = Integer.valueOf(c);
        if (min < 0 || min > 60) {
            return false;
        }
        s = 0;
        c = "";
        while (sp < sl && (szTime.charAt(sp) < '0' || szTime.charAt(sp) > '9')) {
            ++sp;
        }
        while (sp < sl && szTime.charAt(sp) >= '0' && szTime.charAt(sp) <= '9') {
            if (s < 2) {
                c = c + szTime.charAt(sp);
            }
            ++sp;
            ++s;
        }
        if (s > 2) {
            return false;
        }
        int sec = Integer.valueOf(c);
        if (sec < 0 || sec > 60) {
            return false;
        }
        t_time.set(2010, 10, 10, h, min, sec);
        return true;
    }

    public static boolean isTime(String szTime) {
        Calendar t_time = Calendar.getInstance();
        boolean b = StringRegularOpt.isTime(szTime, t_time);
        return b;
    }

    public static String trimDateString(String szDateStr) {
        if (szDateStr == null) {
            return null;
        }
        int sl = szDateStr.length();
        StringBuilder sB = new StringBuilder();
        String sTmp2 = "";
        int nPart = 0;
        boolean bDot = false;
        boolean hasYearPart = false;
        for (int j = 0; j < sl; ++j) {
            if (szDateStr.charAt(j) >= '0' && szDateStr.charAt(j) <= '9') {
                if (bDot) {
                    if (!"".equals(sTmp2)) {
                        if (nPart > 0 && nPart < 3) {
                            sB.append('-');
                        } else if (nPart == 3) {
                            sB.append(' ');
                        } else if (nPart > 3 && nPart < 6) {
                            sB.append(':');
                        }
                        ++nPart;
                        if (sTmp2.length() == 1) {
                            sB.append('0');
                        }
                        if (sTmp2.length() > 0) {
                            sB.append(sTmp2);
                        }
                        sTmp2 = "";
                    }
                    bDot = false;
                }
                if (nPart >= 6) break;
                sTmp2 = sTmp2 + szDateStr.charAt(j);
                if (!(!hasYearPart && nPart <= 3 || sTmp2.length() != 2 && sTmp2.charAt(0) <= '5')) {
                    bDot = true;
                    continue;
                }
                if (nPart >= 3 || sTmp2.length() != 4) continue;
                hasYearPart = true;
                bDot = true;
                continue;
            }
            bDot = true;
        }
        if (!"".equals(sTmp2)) {
            if (nPart > 0 && nPart < 3) {
                sB.append('-');
            } else if (nPart == 3) {
                sB.append(' ');
            } else if (nPart > 3 && nPart < 6) {
                sB.append(':');
            }
            if (sTmp2.length() == 1) {
                sB.append('0');
            }
            if (sTmp2.length() > 0) {
                sB.append(sTmp2);
            }
        }
        return sB.toString();
    }

    public static String trimDigits(String szDigits) {
        if (szDigits == null) {
            return null;
        }
        int sl = szDigits.length();
        StringBuilder sTmp2 = new StringBuilder("");
        for (int j = 0; j < sl; ++j) {
            if (szDigits.charAt(j) < '0' || szDigits.charAt(j) > '9') continue;
            sTmp2.append(szDigits.charAt(j));
        }
        return sTmp2.toString();
    }

    public static String trimNumber(String szNumber) {
        if (szNumber == null) {
            return null;
        }
        boolean sp = false;
        int sl = szNumber.length();
        StringBuilder sTmp2 = new StringBuilder("");
        for (int j = 0; j < sl; ++j) {
            if (szNumber.charAt(j) >= '0' && szNumber.charAt(j) <= '9') {
                sTmp2.append(szNumber.charAt(j));
                continue;
            }
            if (sp || szNumber.charAt(j) != '.') continue;
            sTmp2.append(szNumber.charAt(j));
            sp = true;
        }
        return sTmp2.toString();
    }

    public static String sqlMatchToRegex(String sTempl) {
        return "^" + sTempl.replaceAll("%", "\\\\S*").replaceAll("_", "\\\\S") + "$";
    }

    public static boolean isMatch(String szValue, String szTempl) {
        if (szValue == null || szTempl == null) {
            return false;
        }
        if (szValue.equals(szTempl)) {
            return true;
        }
        int nLV = szValue.length();
        int nLT = szTempl.length();
        if (nLV == 0 && nLT == 0) {
            return true;
        }
        szValue = StringRegularOpt.trimString(szValue);
        szTempl = StringRegularOpt.trimString(szTempl);
        return Pattern.compile(StringRegularOpt.sqlMatchToRegex(szTempl)).matcher(szValue).find();
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public static boolean isChineseEscapeSymbol(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B;
    }

    public static int getFirstChinesePos(String strName) {
        char[] ch = strName.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (!StringRegularOpt.isChinese(c)) continue;
            return i;
        }
        return -1;
    }

    public static int getFirstChinesePosEscapeSymbol(String strName) {
        char[] ch = strName.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (!StringRegularOpt.isChineseEscapeSymbol(c)) continue;
            return i;
        }
        return -1;
    }
}

