/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.jdbc.util;

import cn.dolphin.core.jdbc.util.GeneralAlgorithm;
import cn.dolphin.core.jdbc.util.StringBaseOpt;
import cn.dolphin.core.jdbc.util.StringRegularOpt;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

public abstract class NumberBaseOpt {
    private static final String[] CNum = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CNum2 = new String[]{"\u3007", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] CBit = new String[]{"", "\u62fe", "\u4f70", "\u4edf"};

    private NumberBaseOpt() {
        throw new IllegalAccessError("Utility class");
    }

    public static char getNumByte(String szNum, int nBit) {
        int nPos;
        int sl = szNum.length();
        for (nPos = 0; nPos < sl && szNum.charAt(nPos) != '.'; ++nPos) {
        }
        nPos = nBit < 0 ? (nPos -= nBit) : nPos - nBit - 1;
        if (nPos < 0 || nPos >= sl) {
            return '0';
        }
        return szNum.charAt(nPos);
    }

    public static String capitalization(String szNum) {
        int inl;
        int sl;
        StringBuilder resstr = new StringBuilder();
        String tmpstr = szNum.trim();
        int sp = 0;
        int dotpos = tmpstr.indexOf(46);
        if (dotpos != -1) {
            for (sl = tmpstr.length(); sl > 1 && tmpstr.charAt(sl - 1) == '0'; --sl) {
            }
            if (tmpstr.charAt(sl - 1) == '.') {
                --sl;
            }
            if (sl != tmpstr.length()) {
                tmpstr = tmpstr.substring(0, sl);
            }
        } else {
            dotpos = sl;
        }
        if (sl < 1) {
            return CNum[0];
        }
        if (tmpstr.charAt(0) == '-') {
            resstr.append("\u8d1f");
            sp = 1;
        }
        String integerNum = tmpstr.substring(sp, dotpos - sp);
        String decimalNum = "";
        if (dotpos + 1 < sl) {
            decimalNum = tmpstr.substring(dotpos + 1);
        }
        sl = integerNum.length();
        for (sp = 0; sp < sl && integerNum.charAt(sp) == '0'; ++sp) {
        }
        if (sp > 0) {
            integerNum = integerNum.substring(sp);
        }
        if ((inl = integerNum.length()) > 0) {
            int h = (inl - 1) % 4;
            sp = 0;
            boolean allzero = false;
            boolean preallzero = false;
            for (int j = (inl - 1) / 4 + 1; j > 0; --j) {
                int k = h;
                h = 3;
                boolean preiszero = allzero;
                allzero = true;
                while (k >= 0) {
                    if (integerNum.charAt(sp) == '0') {
                        preiszero = true;
                    } else {
                        allzero = false;
                        if (preiszero) {
                            resstr.append("\u96f6");
                        }
                        preiszero = false;
                        resstr.append(CNum[(byte)integerNum.charAt(sp) - 48]).append(CBit[k]);
                    }
                    --k;
                    ++sp;
                }
                if (j % 2 == 0) {
                    if (!allzero) {
                        resstr.append("\u4e07");
                    }
                } else if (!allzero || !preallzero) {
                    int repyi = j / 2;
                    for (int i = 0; i < repyi; ++i) {
                        resstr.append("\u4ebf");
                    }
                }
                preallzero = allzero;
            }
        } else {
            resstr.append("\u96f6");
        }
        int dnl = decimalNum.length();
        if (dnl > 0) {
            resstr.append("\u70b9");
            for (int i = 0; i < dnl; ++i) {
                resstr.append(CNum[(byte)decimalNum.charAt(i) - 48]);
            }
        }
        return resstr.toString();
    }

    public static String uppercaseCN(String szNum) {
        StringBuilder resstr = new StringBuilder();
        String tmpstr = szNum.trim();
        int sl = tmpstr.length();
        if (sl < 1) {
            return CNum2[0];
        }
        for (int sp = 0; sp < sl; ++sp) {
            if (tmpstr.charAt(sp) >= '0' && tmpstr.charAt(sp) <= '9') {
                resstr.append(CNum2[tmpstr.charAt(sp) - 48]);
                continue;
            }
            resstr.append(tmpstr.charAt(sp));
        }
        return resstr.toString();
    }

    public static String capitalization(String szNum, boolean isSimple) {
        if (isSimple) {
            return NumberBaseOpt.uppercaseCN(szNum);
        }
        return NumberBaseOpt.capitalization(szNum);
    }

    public static boolean isNumber(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Number) {
            return true;
        }
        return StringRegularOpt.isNumber(StringBaseOpt.objectToString(obj));
    }

    public static Long parseLong(String sNum, Long errorValue) {
        Long lValue;
        try {
            lValue = Long.parseLong(StringRegularOpt.trimString(sNum));
        }
        catch (NumberFormatException e) {
            lValue = errorValue;
        }
        return lValue;
    }

    public static Long parseLong(String sNum) {
        return NumberBaseOpt.parseLong(sNum, null);
    }

    public static Integer parseInteger(String sNum, Integer errorValue) {
        Integer lValue;
        try {
            lValue = Integer.parseInt(StringRegularOpt.trimString(sNum));
        }
        catch (NumberFormatException e) {
            lValue = errorValue;
        }
        return lValue;
    }

    public static Integer parseInteger(String sNum) {
        return NumberBaseOpt.parseInteger(sNum, null);
    }

    public static Double parseDouble(String sNum, Double errorValue) {
        Double lValue;
        try {
            lValue = Double.parseDouble(StringRegularOpt.trimString(sNum));
        }
        catch (NumberFormatException e) {
            lValue = errorValue;
        }
        return lValue;
    }

    public static Float parseFloat(String sNum, Float errorValue) {
        Float lValue;
        try {
            lValue = Float.valueOf(Float.parseFloat(StringRegularOpt.trimString(sNum)));
        }
        catch (NumberFormatException e) {
            lValue = errorValue;
        }
        return lValue;
    }

    public static Double parseDouble(String sNum) {
        return NumberBaseOpt.parseDouble(sNum, null);
    }

    public static Long castObjectToLong(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof Date) {
            return ((Date)obj).getTime();
        }
        if (obj instanceof String) {
            return NumberBaseOpt.parseLong((String)obj, null);
        }
        return NumberBaseOpt.parseLong(StringBaseOpt.objectToString(obj), null);
    }

    public static Long castObjectToLong(Object obj, Long defaultValue) {
        return GeneralAlgorithm.nvl(NumberBaseOpt.castObjectToLong(obj), defaultValue);
    }

    public static Integer castObjectToInteger(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof Date) {
            return Long.valueOf(((Date)obj).getTime()).intValue();
        }
        if (obj instanceof String) {
            return NumberBaseOpt.parseInteger((String)obj, null);
        }
        return NumberBaseOpt.parseInteger(StringBaseOpt.objectToString(obj), null);
    }

    public static Integer castObjectToInteger(Object obj, Integer defaultValue) {
        return GeneralAlgorithm.nvl(NumberBaseOpt.castObjectToInteger(obj), defaultValue);
    }

    public static Float castObjectToFloat(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Float) {
            return (Float)obj;
        }
        if (obj instanceof String) {
            return NumberBaseOpt.parseFloat((String)obj, null);
        }
        if (obj instanceof Number) {
            return Float.valueOf(((Number)obj).floatValue());
        }
        return NumberBaseOpt.parseFloat(StringBaseOpt.objectToString(obj), null);
    }

    public static Float castObjectToFloat(Object obj, Float defaultValue) {
        return GeneralAlgorithm.nvl(NumberBaseOpt.castObjectToFloat(obj), defaultValue);
    }

    public static Double castObjectToDouble(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof String) {
            return NumberBaseOpt.parseDouble((String)obj, null);
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        return NumberBaseOpt.parseDouble(StringBaseOpt.objectToString(obj), null);
    }

    public static Double castObjectToDouble(Object obj, Double defaultValue) {
        return GeneralAlgorithm.nvl(NumberBaseOpt.castObjectToDouble(obj), defaultValue);
    }

    public static BigInteger castObjectToBigInteger(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigInteger) {
            return (BigInteger)obj;
        }
        return new BigInteger(StringBaseOpt.objectToString(obj));
    }

    public static BigInteger castObjectToBigInteger(Object obj, BigInteger defaultValue) {
        return GeneralAlgorithm.nvl(NumberBaseOpt.castObjectToBigInteger(obj), defaultValue);
    }

    public static BigDecimal castObjectToBigDecimal(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof BigInteger) {
            return new BigDecimal((BigInteger)obj);
        }
        return new BigDecimal(obj.toString());
    }

    public static BigDecimal castObjectToBigDecimal(Object obj, BigDecimal defaultValue) {
        return GeneralAlgorithm.nvl(NumberBaseOpt.castObjectToBigDecimal(obj), defaultValue);
    }

    public static Number castObjectToNumber(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number) {
            return (Number)obj;
        }
        if (obj instanceof Date) {
            return ((Date)obj).getTime();
        }
        String strNum = StringRegularOpt.trimNumber(StringBaseOpt.castObjectToString(obj));
        if (strNum.indexOf(46) < 0) {
            return NumberBaseOpt.castObjectToLong(strNum);
        }
        return NumberBaseOpt.castObjectToBigDecimal(strNum);
    }
}

