/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.jdbc.util;

import cn.dolphin.core.jdbc.util.StringBaseOpt;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Lexer {
    private String curWord;
    private boolean isBack;
    private String formulaSen;
    private boolean canAcceptOpt;
    private int startPos;
    public static final int LANG_TYPE_DEFAULT = 0;
    public static final int LANG_TYPE_JAVA = 1;
    public static final int LANG_TYPE_SQL = 2;
    private int languageType;

    public Lexer() {
        this.languageType = 1;
        this.setFormula(null);
    }

    public Lexer(String sFormula) {
        this.languageType = 1;
        this.setFormula(sFormula);
    }

    public Lexer(int langType) {
        this.languageType = langType;
        this.setFormula(null);
    }

    public Lexer(String sFormula, int langType) {
        this.languageType = langType;
        this.setFormula(sFormula);
    }

    public void setPreword(String preWord) {
        this.curWord = preWord;
        this.isBack = true;
    }

    public void setFormula(String sFormula) {
        this.formulaSen = sFormula;
        this.isBack = false;
        this.curWord = "";
        this.startPos = 0;
        this.canAcceptOpt = false;
    }

    public boolean isCanAcceptOpt() {
        return this.canAcceptOpt;
    }

    public void setCanAcceptOpt(boolean canAcceptOpt) {
        this.canAcceptOpt = canAcceptOpt;
    }

    public int getCurrPos() {
        return this.startPos;
    }

    public static boolean isLabel(String sWord) {
        if (sWord.length() < 1) {
            return false;
        }
        char c = sWord.charAt(0);
        return c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public String getARawWord() {
        int sl = this.formulaSen.length();
        while (this.startPos < sl && (this.formulaSen.charAt(this.startPos) == ' ' || this.formulaSen.charAt(this.startPos) == '\t' || this.formulaSen.charAt(this.startPos) == '\n' || this.formulaSen.charAt(this.startPos) == '\r')) {
            ++this.startPos;
        }
        if (this.startPos >= sl) {
            return "";
        }
        int bp = this.startPos;
        if (this.formulaSen.charAt(this.startPos) >= '0' && this.formulaSen.charAt(this.startPos) <= '9' || !this.canAcceptOpt && (this.formulaSen.charAt(this.startPos) == '-' || this.formulaSen.charAt(this.startPos) == '+')) {
            ++this.startPos;
            int nPoints = 0;
            while (this.startPos < sl && (this.formulaSen.charAt(this.startPos) >= '0' && this.formulaSen.charAt(this.startPos) <= '9' || this.formulaSen.charAt(this.startPos) == '.') && (this.formulaSen.charAt(this.startPos) != '.' || ++nPoints <= 1)) {
                ++this.startPos;
            }
            this.canAcceptOpt = true;
        } else if (this.formulaSen.charAt(this.startPos) >= 'a' && this.formulaSen.charAt(this.startPos) <= 'z' || this.formulaSen.charAt(this.startPos) >= 'A' && this.formulaSen.charAt(this.startPos) <= 'Z' || this.formulaSen.charAt(this.startPos) == '_' || this.formulaSen.charAt(this.startPos) == '@') {
            ++this.startPos;
            while (this.startPos < sl && (this.formulaSen.charAt(this.startPos) >= '0' && this.formulaSen.charAt(this.startPos) <= '9' || this.formulaSen.charAt(this.startPos) >= 'a' && this.formulaSen.charAt(this.startPos) <= 'z' || this.formulaSen.charAt(this.startPos) >= 'A' && this.formulaSen.charAt(this.startPos) <= 'Z' || this.formulaSen.charAt(this.startPos) == '_' || this.formulaSen.charAt(this.startPos) == '.' || this.formulaSen.charAt(this.startPos) == '@')) {
                ++this.startPos;
            }
            this.canAcceptOpt = true;
        } else {
            this.canAcceptOpt = false;
            switch (this.formulaSen.charAt(this.startPos)) {
                case '+': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '=' && this.formulaSen.charAt(this.startPos) != '+') break;
                    ++this.startPos;
                    break;
                }
                case '-': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '=' && this.formulaSen.charAt(this.startPos) != '-') break;
                    ++this.startPos;
                    break;
                }
                case '*': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '*' && this.formulaSen.charAt(this.startPos) != '=' && this.formulaSen.charAt(this.startPos) != '/') break;
                    ++this.startPos;
                    break;
                }
                case '/': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '=' && this.formulaSen.charAt(this.startPos) != '/' && this.formulaSen.charAt(this.startPos) != '*') break;
                    ++this.startPos;
                    break;
                }
                case '<': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '=' && this.formulaSen.charAt(this.startPos) != '>' && this.formulaSen.charAt(this.startPos) != '<') break;
                    ++this.startPos;
                    break;
                }
                case '>': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '=' && this.formulaSen.charAt(this.startPos) != '>') break;
                    ++this.startPos;
                    break;
                }
                case ':': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '=') break;
                    ++this.startPos;
                    break;
                }
                case '!': 
                case '=': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '=') break;
                    ++this.startPos;
                    break;
                }
                case '|': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '|') break;
                    ++this.startPos;
                    break;
                }
                case '&': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '&') break;
                    ++this.startPos;
                    break;
                }
                case '\"': 
                case '\'': {
                    this.canAcceptOpt = true;
                    ++this.startPos;
                    break;
                }
                case '.': {
                    ++this.startPos;
                    while (this.startPos < sl && this.formulaSen.charAt(this.startPos) >= '0' && this.formulaSen.charAt(this.startPos) <= '9') {
                        ++this.startPos;
                    }
                    break;
                }
                case ')': {
                    this.canAcceptOpt = true;
                    ++this.startPos;
                    break;
                }
                default: {
                    ++this.startPos;
                }
            }
        }
        String str = this.formulaSen.substring(bp, this.startPos);
        return str;
    }

    public String getARegularWord() {
        String s = this.getARawWord();
        int sl = this.formulaSen.length();
        if ("\"".equals(s)) {
            int bp = this.startPos - 1;
            while (this.startPos < sl && this.formulaSen.charAt(this.startPos) != '\"') {
                if (this.languageType == 1 && this.formulaSen.charAt(this.startPos) == '\\') {
                    ++this.startPos;
                }
                ++this.startPos;
            }
            if (this.startPos >= sl) {
                return null;
            }
            ++this.startPos;
            this.canAcceptOpt = true;
            s = this.formulaSen.substring(bp, this.startPos);
        } else if ("'".equals(s)) {
            int bp = this.startPos - 1;
            while (this.startPos < sl && this.formulaSen.charAt(this.startPos) != '\'') {
                if (this.languageType == 1 && this.formulaSen.charAt(this.startPos) == '\\') {
                    ++this.startPos;
                }
                ++this.startPos;
            }
            if (this.startPos >= sl) {
                return null;
            }
            ++this.startPos;
            this.canAcceptOpt = true;
            s = this.formulaSen.substring(bp, this.startPos);
        }
        return s;
    }

    public String getAWord() {
        if (this.isBack) {
            this.isBack = false;
            return this.curWord;
        }
        while (true) {
            this.curWord = this.getARegularWord();
            if (this.curWord == null || "".equals(this.curWord)) break;
            if (this.languageType == 1 && "//".equals(this.curWord) || this.languageType == 2 && "--".equals(this.curWord)) {
                this.seekToLineEnd();
                continue;
            }
            if (this.languageType == 0 || !"/*".equals(this.curWord)) break;
            this.seekToAnnotateEnd();
        }
        return this.curWord;
    }

    public String getAWord(boolean bAcceptOpt) {
        this.canAcceptOpt = bAcceptOpt;
        return this.getAWord();
    }

    public String getARawWord(boolean bAcceptOpt) {
        this.canAcceptOpt = bAcceptOpt;
        return this.getARawWord();
    }

    public void seekToLineEnd() {
        int sl = this.formulaSen.length();
        while (this.startPos < sl && this.formulaSen.charAt(this.startPos) != '\n') {
            ++this.startPos;
        }
    }

    public void seekToAnnotateEnd() {
        int sl = this.formulaSen.length();
        while (this.startPos < sl - 1 && (this.formulaSen.charAt(this.startPos) != '*' || this.formulaSen.charAt(this.startPos + 1) != '/')) {
            ++this.startPos;
        }
        this.startPos = this.startPos < sl - 1 && this.formulaSen.charAt(this.startPos) == '*' && this.formulaSen.charAt(this.startPos + 1) == '/' ? (this.startPos += 2) : sl;
    }

    public boolean seekToRightBracket() {
        int nBracket = 1;
        do {
            String sWord;
            if ((sWord = this.getAWord(false)) == null || sWord.equals("")) {
                return false;
            }
            if (sWord.equals("(")) {
                ++nBracket;
                continue;
            }
            if (!sWord.equals(")")) continue;
            --nBracket;
        } while (nBracket != 0);
        return true;
    }

    public boolean seekToRightSquareBracket() {
        int nBracket = 1;
        do {
            String sWord;
            if ((sWord = this.getAWord(false)) == null || sWord.equals("")) {
                return false;
            }
            if (sWord.equals("[")) {
                ++nBracket;
                continue;
            }
            if (!sWord.equals("]")) continue;
            --nBracket;
        } while (nBracket != 0);
        return true;
    }

    public boolean seekToRightBrace() {
        int nBracket = 1;
        do {
            String sWord;
            if ((sWord = this.getAWord(false)) == null || sWord.equals("")) {
                return false;
            }
            if (sWord.equals("{")) {
                ++nBracket;
                continue;
            }
            if (!sWord.equals("}")) continue;
            --nBracket;
        } while (nBracket != 0);
        return true;
    }

    public void skipAOperand() {
        String sWord;
        int nBracket = 0;
        do {
            if ((sWord = this.getAWord()) == null || sWord.equals("")) {
                return;
            }
            if (sWord.equals("(")) {
                ++nBracket;
                continue;
            }
            if (!sWord.equals(")") || --nBracket >= 0) continue;
            this.setPreword(")");
            return;
        } while (!sWord.equals(",") || nBracket != 0);
        this.setPreword(",");
    }

    public String getStringUntil(String szBreak) {
        String sWord;
        int bp = this.startPos;
        int ep = this.startPos;
        do {
            ep = this.startPos;
        } while ((sWord = this.getAWord(false)) != null && !sWord.equals("") && !sWord.equals(szBreak));
        String str = this.formulaSen.substring(bp, ep);
        return str;
    }

    public void resetToBegin() {
        this.isBack = false;
        this.curWord = "";
        this.startPos = 0;
        this.canAcceptOpt = false;
    }

    public boolean setPosition(int newPos) {
        if (this.formulaSen == null || this.formulaSen.length() <= newPos) {
            return false;
        }
        this.isBack = false;
        this.curWord = "";
        this.startPos = newPos;
        this.canAcceptOpt = false;
        return true;
    }

    public boolean seekTo(char cSplit) {
        int sl = this.formulaSen.length();
        while (this.startPos < sl && this.formulaSen.charAt(this.startPos) != cSplit) {
            ++this.startPos;
        }
        if (this.startPos < sl) {
            ++this.startPos;
            return true;
        }
        return false;
    }

    public boolean seekTo(String aword, boolean skipAnnotate) {
        do {
            String string = this.curWord = skipAnnotate ? this.getAWord() : this.getARegularWord();
            if (this.curWord != null && !"".equals(this.curWord)) continue;
            return false;
        } while (!this.curWord.equals(aword));
        return true;
    }

    public String getBuffer(int bp, int ep) {
        if (ep - bp < 1) {
            return null;
        }
        return this.formulaSen.substring(bp, ep);
    }

    public int findWord(String aword, boolean caseSensitives, boolean skipAnnotate) {
        String cWord;
        String string = cWord = skipAnnotate ? this.getAWord() : this.getARegularWord();
        while (!StringBaseOpt.isNvl(cWord)) {
            if (cWord.equals(aword) || !caseSensitives && cWord.equalsIgnoreCase(aword)) {
                return this.getCurrPos() - cWord.length();
            }
            cWord = skipAnnotate ? this.getAWord() : this.getARegularWord();
        }
        return -1;
    }

    public int getNoteType() {
        return this.languageType;
    }

    public void setNoteType(int noteType) {
        this.languageType = noteType;
    }

    public static List<String> splitByWord(String sourceString, String splitWord) {
        int curPos;
        ArrayList<String> res = new ArrayList<String>();
        Lexer varMorp = new Lexer(sourceString, 0);
        int prePos = curPos = varMorp.getCurrPos();
        String aWord = varMorp.getARawWord();
        while (StringUtils.isNotBlank((CharSequence)aWord)) {
            if ("(".equals(aWord)) {
                varMorp.seekToRightBracket();
                curPos = varMorp.getCurrPos();
                aWord = varMorp.getARawWord();
            }
            if ("{".equals(aWord)) {
                varMorp.seekToRightBrace();
                curPos = varMorp.getCurrPos();
                aWord = varMorp.getARawWord();
            }
            if ("[".equals(aWord)) {
                varMorp.seekToRightSquareBracket();
                curPos = varMorp.getCurrPos();
                aWord = varMorp.getARawWord();
            }
            if (StringUtils.equals((CharSequence)aWord, (CharSequence)splitWord)) {
                res.add(sourceString.substring(prePos, curPos));
                prePos = varMorp.getCurrPos();
            }
            curPos = varMorp.getCurrPos();
            aWord = varMorp.getARawWord();
        }
        curPos = varMorp.getCurrPos();
        res.add(sourceString.substring(prePos, curPos));
        return res;
    }

    public static String getFirstWord(String str) {
        return new Lexer(str).getARawWord();
    }
}

