/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.jdbc.util;

import cn.dolphin.core.exception.DaoRuntimException;
import cn.dolphin.core.jdbc.annotation.Field;
import cn.dolphin.core.jdbc.annotation.Table;
import cn.dolphin.core.jdbc.enums.FieldType;
import cn.dolphin.core.jdbc.model.BatchModel;
import cn.dolphin.core.jdbc.model.SaveOrUpdateModel;
import cn.dolphin.core.jdbc.model.SqlModel;
import cn.dolphin.core.map.MapUtil;
import cn.dolphin.core.reflect.BeanField;
import cn.dolphin.core.reflect.ReflectUtil;
import cn.dolphin.core.util.ArrayUtil;
import cn.dolphin.core.util.CamelCaseUtil;
import cn.dolphin.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUtil {
    protected static Logger log = LoggerFactory.getLogger(JdbcUtil.class);
    protected static HashMap<String, String> tableMap = new HashMap();
    protected static HashMap<String, String> pkMap = new HashMap();

    public static String getTableName(Class<?> clazz) {
        String name = clazz.getName();
        String tableName = tableMap.get(name);
        if (tableName != null) {
            return tableName;
        }
        Table tb = clazz.getAnnotation(Table.class);
        tableName = tb != null ? (tb.value() != null && !tb.value().isEmpty() ? tb.value() : CamelCaseUtil.toUnderlineName(clazz.getSimpleName())) : CamelCaseUtil.toUnderlineName(clazz.getSimpleName());
        tableMap.put(name, tableName);
        return tableName;
    }

    public static String getPk(Class<?> clazz) {
        String tableName = JdbcUtil.getTableName(clazz);
        String pkColumn = MapUtil.getString(pkMap, tableName);
        if (StrUtil.isNotBlank((CharSequence)pkColumn)) {
            return pkColumn;
        }
        List<BeanField> fields = ReflectUtil.getBeanFields(clazz);
        Field annotation = null;
        for (BeanField field : fields) {
            annotation = field.getAnnotation(Field.class);
            if (null == annotation || !annotation.isPK()) continue;
            pkColumn = CamelCaseUtil.toUnderlineName(field.getName());
            pkMap.put(tableName, pkColumn);
        }
        return pkColumn;
    }

    public static <T> SqlModel buildUpdateModel(T t, String[] limitColumns, boolean ignore, String mark) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        StringBuilder sql_set = new StringBuilder();
        Class<?> clazz = t.getClass();
        String table = JdbcUtil.getTableName(clazz);
        List<BeanField> fields = ReflectUtil.getBeanFields(clazz);
        int length = fields.size();
        Object[] values = new Object[length];
        int[] types = new int[length];
        Object value = null;
        int i = 0;
        String column = null;
        Field annotation = null;
        String pkColumn = null;
        Object pkValue = null;
        for (BeanField field : fields) {
            String fieldName = field.getName();
            column = CamelCaseUtil.toUnderlineName(fieldName);
            annotation = field.getAnnotation(Field.class);
            if (annotation != null) {
                if (!annotation.isColumn() || annotation.readOnly()) continue;
                if (annotation.value() != null && !annotation.value().isEmpty()) {
                    column = annotation.value();
                }
                if (annotation.isPK()) {
                    Method pkMethod = field.getGetterMethod();
                    if (pkMethod == null) {
                        throw new DaoRuntimException("No getter method: " + fieldName);
                    }
                    pkValue = pkMethod.invoke(t, new Object[0]);
                    pkColumn = column;
                    continue;
                }
            }
            if (ignore ? limitColumns != null && ArrayUtil.isInArray(column, limitColumns) : limitColumns != null && !ArrayUtil.isInArray(column, limitColumns)) continue;
            Method method = field.getGetterMethod();
            Class<List> fieldType = method.getReturnType();
            if (annotation != null && annotation.isJson()) {
                value = method.invoke(t, new Object[0]);
                value = fieldType.isAssignableFrom(List.class) ? JSONArray.toJSONString((Object)value) : JSONObject.toJSONString((Object)value);
                types[i] = -1;
            } else {
                Integer type = JdbcUtil.toSqlType(fieldType);
                if (type == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Attribute type is not supported: name=" + fieldName + "; type=" + fieldType.getName());
                    continue;
                }
                types[i] = type;
                value = method.invoke(t, new Object[0]);
            }
            sql_set.append(",").append(mark).append(column).append(mark).append("=?");
            values[i] = value;
            ++i;
        }
        StringBuilder sql = new StringBuilder("UPDATE ");
        sql.append(" ").append(table);
        sql.append(" SET ").append(sql_set.substring(1));
        sql.append(" WHERE ").append(pkColumn).append("=?");
        Object[] newValues = new Object[i + 1];
        newValues[i] = pkValue;
        for (int j = 0; j < i; ++j) {
            newValues[j] = values[j];
        }
        values = newValues;
        int[] newTypes = new int[i + 1];
        newTypes[i] = 12;
        for (int j = 0; j < i; ++j) {
            newTypes[j] = types[j];
        }
        types = newTypes;
        return new SqlModel(sql.toString(), values, types, pkColumn);
    }

    public static SaveOrUpdateModel buildSaveOrUpdateModel(Object t) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> clazz = t.getClass();
        String table = JdbcUtil.getTableName(clazz);
        List<BeanField> fields = ReflectUtil.getBeanFields(clazz);
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        Object value = null;
        String column = null;
        Field annotation = null;
        String pkName = null;
        Object pkValue = null;
        for (BeanField field : fields) {
            String fieldName = field.getName();
            annotation = field.getAnnotation(Field.class);
            if (annotation != null) {
                if (!annotation.isColumn() || annotation.readOnly()) continue;
                column = annotation.value() != null && !annotation.value().isEmpty() ? annotation.value() : CamelCaseUtil.toUnderlineName(fieldName);
            } else {
                column = CamelCaseUtil.toUnderlineName(fieldName);
            }
            Method method = field.getGetterMethod();
            if (method == null) continue;
            Class<List> fieldType = method.getReturnType();
            if (annotation != null && annotation.isJson()) {
                value = method.invoke(t, new Object[0]);
                value = fieldType.isAssignableFrom(List.class) ? JSONArray.toJSONString((Object)value) : JSONObject.toJSONString((Object)value);
                types.add(-1);
            } else {
                Integer type = JdbcUtil.toSqlType(fieldType);
                if (type == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Attribute type is not supported: name=" + fieldName + "; type=" + fieldType.getName());
                    continue;
                }
                types.add(type);
                value = method.invoke(t, new Object[0]);
                if (annotation != null) {
                    if (annotation.isPK()) {
                        pkValue = value;
                        pkName = column;
                    }
                    if (annotation.Seq() != null && !annotation.Seq().isEmpty() && (value == null || "".equals(value + "") || "0".equals(value))) {
                        value = annotation.Seq() + ".NEXTVAL";
                    }
                }
            }
            columns.add(column);
            values.add(value);
        }
        return new SaveOrUpdateModel(table, pkName, pkValue, columns, values, types);
    }

    public static <T> BatchModel buildBatchSaveModel(List<T> list, String mark) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        StringBuilder sql_fields = new StringBuilder();
        StringBuilder sql_values = new StringBuilder();
        int i = 0;
        T t = list.get(0);
        Class<?> clazz = t.getClass();
        String table = JdbcUtil.getTableName(clazz);
        List<BeanField> fields = ReflectUtil.getBeanFields(clazz);
        int length = fields.size();
        Method[] methods = new Method[length];
        int[] types = new int[length];
        FieldType[] valueFlag = new FieldType[length];
        String column = null;
        Field annotation = null;
        for (BeanField field : fields) {
            Class<?> fieldType;
            String fieldName = field.getName();
            annotation = field.getAnnotation(Field.class);
            if (annotation != null) {
                if (!annotation.isColumn() || annotation.readOnly()) continue;
                column = annotation.value() != null && !annotation.value().isEmpty() ? annotation.value() : CamelCaseUtil.toUnderlineName(fieldName);
                if (annotation.Seq() != null && !annotation.Seq().isEmpty()) {
                    sql_fields.append(",").append(mark).append(column).append(mark);
                    sql_values.append(",").append(annotation.Seq()).append(".NEXTVAL");
                    continue;
                }
            } else {
                column = CamelCaseUtil.toUnderlineName(fieldName);
            }
            if (!JdbcUtil.toSqlType(annotation, fieldType = field.getType(), types, valueFlag, i)) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Attribute type is not supported: name=" + fieldName + "; type=" + fieldType.getName());
                continue;
            }
            methods[i] = field.getGetterMethod();
            if (methods[i] == null) continue;
            sql_fields.append(",").append(mark).append(column).append(mark);
            sql_values.append(",?");
            ++i;
        }
        StringBuilder sql = new StringBuilder("INSERT INTO");
        sql.append(" ").append(table);
        sql.append(" (").append(sql_fields.substring(1)).append(")");
        sql.append(" VALUES (").append(sql_values.substring(1)).append(")");
        if (i != length) {
            types = ArrayUtil.subArray(types, i);
        }
        ArrayList<Object[]> valueList = new ArrayList<Object[]>();
        for (T obj : list) {
            Object[] values = new Object[i];
            JdbcUtil.setValues(values, valueFlag, obj, i, methods);
            valueList.add(values);
        }
        return new BatchModel(sql.toString(), valueList, types);
    }

    public static <T> SqlModel buildSaveModel(T t, String mark) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        StringBuilder sql_fields = new StringBuilder();
        StringBuilder sql_values = new StringBuilder();
        Object value = null;
        int i = 0;
        Class<?> clazz = t.getClass();
        String table = JdbcUtil.getTableName(clazz);
        List<BeanField> fields = ReflectUtil.getBeanFields(clazz);
        int length = fields.size();
        Object[] values = new Object[length];
        int[] types = new int[length];
        String column = null;
        Field annotation = null;
        String pk = null;
        for (BeanField field : fields) {
            Method method;
            String fieldName = field.getName();
            annotation = field.getAnnotation(Field.class);
            if (annotation != null) {
                if (!annotation.isColumn() || annotation.readOnly()) continue;
                column = annotation.value() != null && !"".equals(annotation.value()) ? annotation.value() : CamelCaseUtil.toUnderlineName(fieldName);
                if (annotation.isPK()) {
                    pk = column;
                }
                if (annotation.Seq() != null && !"".equals(annotation.Seq())) {
                    sql_fields.append(",").append(mark).append(column).append(mark);
                    sql_values.append(",").append(annotation.Seq()).append(".NEXTVAL");
                    continue;
                }
            } else {
                column = CamelCaseUtil.toUnderlineName(fieldName);
            }
            if ((method = field.getGetterMethod()) == null) continue;
            Class<List> fieldType = method.getReturnType();
            if (annotation != null && annotation.isJson()) {
                value = method.invoke(t, new Object[0]);
                if (value == null) continue;
                value = fieldType.isAssignableFrom(List.class) ? JSONArray.toJSONString((Object)value) : JSONObject.toJSONString((Object)value);
                types[i] = -1;
            } else {
                Integer type = JdbcUtil.toSqlType(fieldType);
                if (type == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Attribute type is not supported: name=" + fieldName + "; type=" + fieldType.getName());
                    continue;
                }
                types[i] = type;
                value = method.invoke(t, new Object[0]);
                if (value == null) continue;
            }
            sql_fields.append(",").append(mark).append(column).append(mark);
            sql_values.append(",?");
            values[i] = value;
            ++i;
        }
        StringBuilder sql = new StringBuilder("INSERT INTO");
        sql.append(" ").append(table);
        sql.append(" (").append(sql_fields.substring(1)).append(")");
        sql.append(" VALUES (").append(sql_values.substring(1)).append(")");
        if (i != length) {
            types = ArrayUtil.subArray(types, i);
            values = ArrayUtil.subArray(values, i);
        }
        return new SqlModel(sql.toString(), values, types, pk);
    }

    public static <T> BatchModel buildBatchUpdateModel(List<T> list, String[] limitColumns, boolean ignore, String mark) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        StringBuilder sql_set = new StringBuilder();
        Class<?> clazz = list.get(0).getClass();
        String table = JdbcUtil.getTableName(clazz);
        List<BeanField> fields = ReflectUtil.getBeanFields(clazz);
        int length = fields.size();
        Method[] methods = new Method[length];
        int[] types = new int[length];
        FieldType[] valueFlag = new FieldType[length];
        int i = 0;
        String column = null;
        Field annotation = null;
        Method pkMethod = null;
        String pkColumn = null;
        for (BeanField field : fields) {
            String fieldName = field.getName();
            column = CamelCaseUtil.toUnderlineName(fieldName);
            annotation = field.getAnnotation(Field.class);
            if (annotation != null) {
                if (!annotation.isColumn() || annotation.readOnly()) continue;
                if (annotation.value() != null && !annotation.value().isEmpty()) {
                    column = annotation.value();
                }
                if (annotation.isPK()) {
                    pkMethod = field.getGetterMethod();
                    if (pkMethod == null) {
                        throw new DaoRuntimException("No getter method: " + fieldName);
                    }
                    pkColumn = column;
                    continue;
                }
            }
            if (!ignore ? limitColumns != null && !ArrayUtil.isInArray(column, limitColumns) : limitColumns != null && ArrayUtil.isInArray(column, limitColumns)) continue;
            Class<?> fieldType = field.getType();
            if (!JdbcUtil.toSqlType(annotation, fieldType, types, valueFlag, i)) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Attribute type is not supported: name=" + fieldName + "; type=" + fieldType.getName());
                continue;
            }
            methods[i] = field.getGetterMethod();
            if (methods[i] == null) continue;
            sql_set.append(",").append(mark).append(column).append(mark).append("=?");
            ++i;
        }
        StringBuilder sql = new StringBuilder("UPDATE ");
        sql.append(" ").append(table);
        sql.append(" SET ").append(sql_set.substring(1));
        sql.append(" WHERE ").append(pkColumn).append("=?");
        int[] newTypes = new int[i + 1];
        newTypes[i] = 12;
        for (int j = 0; j < i; ++j) {
            newTypes[j] = types[j];
        }
        types = newTypes;
        ArrayList<Object[]> valueList = new ArrayList<Object[]>();
        for (T obj : list) {
            Object[] values = new Object[i + 1];
            JdbcUtil.setValues(values, valueFlag, obj, i, methods);
            values[i] = pkMethod.invoke(obj, new Object[0]);
            valueList.add(values);
        }
        return new BatchModel(sql.toString(), valueList, types);
    }

    private static final void setValues(Object[] values, FieldType[] valueFlag, Object obj, int size, Method[] methods) throws InvocationTargetException, IllegalAccessException {
        for (int j = 0; j < size; ++j) {
            Object value = methods[j].invoke(obj, new Object[0]);
            values[j] = valueFlag[j] == FieldType.JSON_ARRAY ? JSONArray.toJSONString((Object)value) : (valueFlag[j] == FieldType.JSON_OBJECT ? JSONObject.toJSONString((Object)value) : value);
        }
    }

    private static final Integer toSqlType(Class fieldType) {
        if (fieldType == String.class) {
            return 12;
        }
        if (fieldType == Integer.class || fieldType == Integer.TYPE) {
            return 4;
        }
        if (fieldType == Long.class || fieldType == Long.TYPE) {
            return -5;
        }
        if (fieldType == Float.class || fieldType == Float.TYPE) {
            return 6;
        }
        if (fieldType == Double.class || fieldType == Double.TYPE) {
            return 8;
        }
        if (fieldType == java.util.Date.class) {
            return 93;
        }
        if (fieldType == byte[].class) {
            return 2004;
        }
        if (fieldType == Short.class || fieldType == Short.TYPE) {
            return 5;
        }
        if (fieldType == Timestamp.class) {
            return 93;
        }
        if (fieldType == Date.class) {
            return 91;
        }
        return null;
    }

    private static final boolean toSqlType(Field annotation, Class fieldType, int[] types, FieldType[] valueFlag, int i) {
        if (annotation != null && annotation.isJson()) {
            valueFlag[i] = fieldType.isAssignableFrom(List.class) || fieldType.isArray() ? FieldType.JSON_ARRAY : FieldType.JSON_OBJECT;
            types[i] = -1;
        } else {
            Integer type = JdbcUtil.toSqlType(fieldType);
            if (type == null) {
                return false;
            }
            types[i] = type;
        }
        return true;
    }

    public static String parseHql(String sql, int type) {
        int where = sql.indexOf(" WHERE ");
        int order = sql.indexOf(" ORDER BY ");
        switch (type) {
            case 1: {
                if (where > 0) {
                    return sql.substring(0, where);
                }
                if (order > 0) {
                    return sql.substring(0, order);
                }
                return sql;
            }
            case 2: {
                if (where > 0) {
                    if (order > 0) {
                        return sql.substring(where, order);
                    }
                    return sql.substring(where);
                }
                return null;
            }
        }
        return null;
    }
}

