/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.jdbc.util;

import cn.dolphin.core.jdbc.util.NumberBaseOpt;
import cn.dolphin.core.jdbc.util.StringBaseOpt;
import cn.dolphin.core.reflect.ReflectUtil;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang3.ObjectUtils;

public abstract class GeneralAlgorithm {
    private GeneralAlgorithm() {
        throw new IllegalAccessError("Utility class");
    }

    public static <T> T nvl(T obj, T obj2) {
        return obj == null ? obj2 : obj;
    }

    public static <T> T nvl2(Object obj, T obj2, T obj3) {
        return obj == null ? obj3 : obj2;
    }

    public static int compareTwoObject(Object operand, Object operand2) {
        if (operand == null && operand2 == null) {
            return 0;
        }
        if (operand == null) {
            return -1;
        }
        if (operand2 == null) {
            return 1;
        }
        if (NumberBaseOpt.isNumber(operand) && NumberBaseOpt.isNumber(operand2)) {
            return ObjectUtils.compare((Comparable)NumberBaseOpt.castObjectToDouble(operand), (Comparable)NumberBaseOpt.castObjectToDouble(operand2));
        }
        return ObjectUtils.compare((Comparable)((Object)StringBaseOpt.objectToString(operand)), (Comparable)((Object)StringBaseOpt.objectToString(operand2)));
    }

    public static <T extends Comparable<? super T>> int compareTwoComparableObject(T l1, T l2) {
        return l1 == null && l2 == null ? 0 : (l1 == null ? -1 : (l2 == null ? 1 : l1.compareTo(l2)));
    }

    private static int getJavaTypeOrder(Object a) {
        switch (ReflectUtil.getJavaTypeName(a.getClass())) {
            case "int": 
            case "Integer": {
                return 1;
            }
            case "long": 
            case "Long": {
                return 2;
            }
            case "float": 
            case "Float": {
                return 3;
            }
            case "double": 
            case "Double": {
                return 4;
            }
            case "BigInteger": {
                return 5;
            }
            case "BigDecimal": {
                return 6;
            }
            case "String": {
                return 10;
            }
        }
        return 100;
    }

    public static Object addTwoObject(Object a, Object b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a instanceof Number && b instanceof Number) {
            int retType = Math.max(GeneralAlgorithm.getJavaTypeOrder(a), GeneralAlgorithm.getJavaTypeOrder(b));
            switch (retType) {
                case 1: {
                    return NumberBaseOpt.castObjectToInteger(a) + NumberBaseOpt.castObjectToInteger(b);
                }
                case 2: {
                    return NumberBaseOpt.castObjectToLong(a) + NumberBaseOpt.castObjectToLong(b);
                }
                case 3: {
                    return Float.valueOf(NumberBaseOpt.castObjectToFloat(a).floatValue() + NumberBaseOpt.castObjectToFloat(b).floatValue());
                }
                case 5: {
                    return NumberBaseOpt.castObjectToBigInteger(a).add(NumberBaseOpt.castObjectToBigInteger(b));
                }
                case 6: {
                    return NumberBaseOpt.castObjectToBigDecimal(a).add(NumberBaseOpt.castObjectToBigDecimal(b));
                }
            }
            return NumberBaseOpt.castObjectToDouble(a) + NumberBaseOpt.castObjectToDouble(b);
        }
        return StringBaseOpt.concat(StringBaseOpt.castObjectToString(a), StringBaseOpt.castObjectToString(b));
    }

    public static Object subtractTwoObject(Object a, Object b) {
        if (b == null) {
            return a;
        }
        if (a == null) {
            a = new Integer(0);
        }
        if (a instanceof Number && b instanceof Number) {
            int retType = Math.max(GeneralAlgorithm.getJavaTypeOrder(a), GeneralAlgorithm.getJavaTypeOrder(b));
            switch (retType) {
                case 1: {
                    return NumberBaseOpt.castObjectToInteger(a) - NumberBaseOpt.castObjectToInteger(b);
                }
                case 2: {
                    return NumberBaseOpt.castObjectToLong(a) - NumberBaseOpt.castObjectToLong(b);
                }
                case 3: {
                    return Float.valueOf(NumberBaseOpt.castObjectToFloat(a).floatValue() - NumberBaseOpt.castObjectToFloat(b).floatValue());
                }
                case 5: {
                    return NumberBaseOpt.castObjectToBigInteger(a).subtract(NumberBaseOpt.castObjectToBigInteger(b));
                }
                case 6: {
                    return NumberBaseOpt.castObjectToBigDecimal(a).subtract(NumberBaseOpt.castObjectToBigDecimal(b));
                }
            }
            return NumberBaseOpt.castObjectToDouble(a) - NumberBaseOpt.castObjectToDouble(b);
        }
        return a;
    }

    public static Object multiplyTwoObject(Object a, Object b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a instanceof Number && b instanceof Number) {
            int retType = Math.max(GeneralAlgorithm.getJavaTypeOrder(a), GeneralAlgorithm.getJavaTypeOrder(b));
            switch (retType) {
                case 1: {
                    return NumberBaseOpt.castObjectToInteger(a) * NumberBaseOpt.castObjectToInteger(b);
                }
                case 2: {
                    return NumberBaseOpt.castObjectToLong(a) * NumberBaseOpt.castObjectToLong(b);
                }
                case 3: {
                    return Float.valueOf(NumberBaseOpt.castObjectToFloat(a).floatValue() * NumberBaseOpt.castObjectToFloat(b).floatValue());
                }
                case 5: {
                    return NumberBaseOpt.castObjectToBigInteger(a).multiply(NumberBaseOpt.castObjectToBigInteger(b));
                }
                case 6: {
                    return NumberBaseOpt.castObjectToBigDecimal(a).multiply(NumberBaseOpt.castObjectToBigDecimal(b));
                }
            }
            return NumberBaseOpt.castObjectToDouble(a) * NumberBaseOpt.castObjectToDouble(b);
        }
        return StringBaseOpt.concat(StringBaseOpt.castObjectToString(a), StringBaseOpt.castObjectToString(b));
    }

    public static Object divideTwoObject(Object a, Object b) {
        if (a == null || b == null) {
            return null;
        }
        if (a instanceof Number && b instanceof Number) {
            int retType = Math.max(GeneralAlgorithm.getJavaTypeOrder(a), GeneralAlgorithm.getJavaTypeOrder(b));
            switch (retType) {
                case 1: {
                    return NumberBaseOpt.castObjectToInteger(a) / NumberBaseOpt.castObjectToInteger(b);
                }
                case 2: {
                    return NumberBaseOpt.castObjectToLong(a) / NumberBaseOpt.castObjectToLong(b);
                }
                case 3: {
                    return Float.valueOf(NumberBaseOpt.castObjectToFloat(a).floatValue() / NumberBaseOpt.castObjectToFloat(b).floatValue());
                }
                case 5: {
                    return NumberBaseOpt.castObjectToBigInteger(a).divide(NumberBaseOpt.castObjectToBigInteger(b));
                }
                case 6: {
                    return NumberBaseOpt.castObjectToBigDecimal(a).divide(NumberBaseOpt.castObjectToBigDecimal(b), 8, RoundingMode.HALF_EVEN);
                }
            }
            return NumberBaseOpt.castObjectToDouble(a) / NumberBaseOpt.castObjectToDouble(b);
        }
        return a;
    }

    public static Object modTwoObject(Object a, Object b) {
        if (a == null || b == null) {
            return null;
        }
        if (a instanceof Number && b instanceof Number) {
            int retType = Math.max(GeneralAlgorithm.getJavaTypeOrder(a), GeneralAlgorithm.getJavaTypeOrder(b));
            switch (retType) {
                case 1: {
                    return NumberBaseOpt.castObjectToInteger(a) % NumberBaseOpt.castObjectToInteger(b);
                }
                case 2: {
                    return NumberBaseOpt.castObjectToLong(a) % NumberBaseOpt.castObjectToLong(b);
                }
                case 3: {
                    return Float.valueOf(NumberBaseOpt.castObjectToFloat(a).floatValue() % NumberBaseOpt.castObjectToFloat(b).floatValue());
                }
                case 5: {
                    return NumberBaseOpt.castObjectToBigInteger(a).mod(NumberBaseOpt.castObjectToBigInteger(b));
                }
            }
            return NumberBaseOpt.castObjectToDouble(a) % NumberBaseOpt.castObjectToDouble(b);
        }
        return a;
    }

    public static Object maxObject(Collection<Object> ar) {
        if (ar.size() < 1) {
            return null;
        }
        Iterator<Object> ari = ar.iterator();
        Object maxObject = ar.iterator().next();
        if (ar.size() == 1) {
            return maxObject;
        }
        int retType = GeneralAlgorithm.getJavaTypeOrder(maxObject);
        block8: while (ari.hasNext()) {
            Object anOther = ari.next();
            retType = Math.max(retType, GeneralAlgorithm.getJavaTypeOrder(anOther));
            switch (retType) {
                case 1: {
                    maxObject = Math.max(NumberBaseOpt.castObjectToInteger(maxObject), NumberBaseOpt.castObjectToInteger(anOther));
                    continue block8;
                }
                case 2: {
                    maxObject = Math.max(NumberBaseOpt.castObjectToLong(maxObject), NumberBaseOpt.castObjectToLong(anOther));
                    continue block8;
                }
                case 3: {
                    maxObject = Float.valueOf(Math.max(NumberBaseOpt.castObjectToFloat(maxObject).floatValue(), NumberBaseOpt.castObjectToFloat(anOther).floatValue()));
                    continue block8;
                }
                case 5: {
                    maxObject = NumberBaseOpt.castObjectToBigInteger(maxObject).max(NumberBaseOpt.castObjectToBigInteger(anOther));
                    continue block8;
                }
                case 6: {
                    maxObject = NumberBaseOpt.castObjectToBigDecimal(maxObject).max(NumberBaseOpt.castObjectToBigDecimal(anOther));
                    continue block8;
                }
                case 4: {
                    maxObject = Math.max(NumberBaseOpt.castObjectToDouble(maxObject), NumberBaseOpt.castObjectToDouble(anOther));
                    continue block8;
                }
            }
            String str1 = StringBaseOpt.castObjectToString(maxObject);
            String str2 = StringBaseOpt.castObjectToString(anOther);
            maxObject = str1.compareTo(str2) > 0 ? str1 : str2;
        }
        return maxObject;
    }

    public static Object minObject(Collection<Object> ar) {
        if (ar.size() < 1) {
            return null;
        }
        Iterator<Object> ari = ar.iterator();
        Object minObject = ar.iterator().next();
        if (ar.size() == 1) {
            return minObject;
        }
        int retType = GeneralAlgorithm.getJavaTypeOrder(minObject);
        block8: while (ari.hasNext()) {
            Object anOther = ari.next();
            retType = Math.max(retType, GeneralAlgorithm.getJavaTypeOrder(anOther));
            switch (retType) {
                case 1: {
                    minObject = Math.min(NumberBaseOpt.castObjectToInteger(minObject), NumberBaseOpt.castObjectToInteger(anOther));
                    continue block8;
                }
                case 2: {
                    minObject = Math.min(NumberBaseOpt.castObjectToLong(minObject), NumberBaseOpt.castObjectToLong(anOther));
                    continue block8;
                }
                case 3: {
                    minObject = Float.valueOf(Math.min(NumberBaseOpt.castObjectToFloat(minObject).floatValue(), NumberBaseOpt.castObjectToFloat(anOther).floatValue()));
                    continue block8;
                }
                case 5: {
                    minObject = NumberBaseOpt.castObjectToBigInteger(minObject).min(NumberBaseOpt.castObjectToBigInteger(anOther));
                    continue block8;
                }
                case 6: {
                    minObject = NumberBaseOpt.castObjectToBigDecimal(minObject).min(NumberBaseOpt.castObjectToBigDecimal(anOther));
                    continue block8;
                }
                case 4: {
                    minObject = Math.min(NumberBaseOpt.castObjectToDouble(minObject), NumberBaseOpt.castObjectToDouble(anOther));
                    continue block8;
                }
            }
            String str1 = StringBaseOpt.castObjectToString(minObject);
            String str2 = StringBaseOpt.castObjectToString(anOther);
            minObject = str1.compareTo(str2) < 0 ? str1 : str2;
        }
        return minObject;
    }

    public static Object sumObjects(Collection<Object> ar) {
        if (ar.size() < 1) {
            return null;
        }
        Iterator<Object> ari = ar.iterator();
        Object sumObj = ar.iterator().next();
        if (ar.size() == 1) {
            return sumObj;
        }
        int retType = GeneralAlgorithm.getJavaTypeOrder(sumObj);
        block8: while (ari.hasNext()) {
            Object anOther = ari.next();
            retType = Math.max(retType, GeneralAlgorithm.getJavaTypeOrder(anOther));
            switch (retType) {
                case 1: {
                    sumObj = NumberBaseOpt.castObjectToInteger(sumObj) + NumberBaseOpt.castObjectToInteger(anOther);
                    continue block8;
                }
                case 2: {
                    sumObj = NumberBaseOpt.castObjectToLong(sumObj) + NumberBaseOpt.castObjectToLong(anOther);
                    continue block8;
                }
                case 3: {
                    sumObj = Float.valueOf(NumberBaseOpt.castObjectToFloat(sumObj).floatValue() + NumberBaseOpt.castObjectToFloat(anOther).floatValue());
                    continue block8;
                }
                case 5: {
                    sumObj = NumberBaseOpt.castObjectToBigInteger(sumObj).add(NumberBaseOpt.castObjectToBigInteger(anOther));
                    continue block8;
                }
                case 6: {
                    sumObj = NumberBaseOpt.castObjectToBigDecimal(sumObj).add(NumberBaseOpt.castObjectToBigDecimal(anOther));
                    continue block8;
                }
                case 4: {
                    sumObj = NumberBaseOpt.castObjectToDouble(sumObj) + NumberBaseOpt.castObjectToDouble(anOther);
                    continue block8;
                }
            }
            sumObj = StringBaseOpt.concat(StringBaseOpt.castObjectToString(sumObj), StringBaseOpt.castObjectToString(anOther));
        }
        return sumObj;
    }
}

