/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.jdbc.support;

import cn.dolphin.core.util.CamelCaseUtil;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.jdbc.core.RowMapper;

public class CommonObj<E>
implements RowMapper<Object> {
    private Class<?> cl;

    public CommonObj(Class<?> cl) {
        this.cl = cl;
    }

    public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
        try {
            Field[] fields = this.cl.getDeclaredFields();
            Object entity = this.cl.newInstance();
            for (Field f : fields) {
                f.setAccessible(true);
                this.typeMapper(f, entity, rs);
                f.setAccessible(false);
            }
            return entity;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void typeMapper(Field field, Object obj, ResultSet rs) throws Exception {
        String type = field.getType().getName();
        if (type.equals("java.lang.String")) {
            field.set(obj, rs.getString(CamelCaseUtil.toUnderlineName(field.getName(), false)));
        } else if (type.equals("int") || type.equals("java.lang.Integer")) {
            field.set(obj, rs.getInt(CamelCaseUtil.toUnderlineName(field.getName(), false)));
        } else if (type.equals("long") || type.equals("java.lang.Long")) {
            field.set(obj, rs.getLong(CamelCaseUtil.toUnderlineName(field.getName(), false)));
        } else if (type.equals("boolean") || type.equals("java.lang.Boolean")) {
            field.set(obj, rs.getBoolean(CamelCaseUtil.toUnderlineName(field.getName(), false)));
        } else if (type.equals("java.util.Date")) {
            field.set(obj, rs.getDate(CamelCaseUtil.toUnderlineName(field.getName(), false)));
        } else if (type.equals("java.sql.Timestamp")) {
            field.set(obj, rs.getTimestamp(CamelCaseUtil.toUnderlineName(field.getName(), false)));
        }
    }
}

