/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.jdbc.support;

import cn.dolphin.core.jdbc.JdbcTemplatePlus;
import cn.dolphin.core.jdbc.support.SQL;
import cn.dolphin.core.page.cache.Cache;
import cn.dolphin.core.page.cache.CacheFactory;
import cn.dolphin.core.util.CamelCaseUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public abstract class AbstractJdbcDao<T, ID extends Serializable>
extends SQL {
    protected static Logger log = LoggerFactory.getLogger(AbstractJdbcDao.class);
    protected Class<T> entityClass;
    protected String tableName;
    protected String primaryKey;
    private static Cache<String, Integer> pageCache = null;

    public abstract JdbcTemplatePlus getJdbcTemplate();

    protected abstract RowMapper<T> getRowMapper();

    protected SqlParameterSource transToSource(Object mapORpojo) {
        if (mapORpojo == null) {
            return new MapSqlParameterSource();
        }
        BeanPropertySqlParameterSource source = null;
        if (mapORpojo instanceof Map) {
            Map map = (Map)mapORpojo;
            source = new MapSqlParameterSource(map);
        } else {
            source = new BeanPropertySqlParameterSource(mapORpojo);
        }
        return source;
    }

    protected String buildTableName(String tableName) {
        return String.format("%s" + tableName + "%s", "`", "`");
    }

    protected StringBuffer buildFields(String[] fields) {
        StringBuffer fieldTemp = new StringBuffer();
        if (fields != null && fields.length > 0) {
            for (String field : fields) {
                fieldTemp.append(CamelCaseUtil.toUnderlineName("field", false)).append(",");
            }
            fieldTemp.deleteCharAt(fieldTemp.length() - 1);
        }
        return fieldTemp;
    }

    protected String buildQuestion(String[] fields) {
        String questionList = StringUtils.repeat((String)"?,", (int)fields.length);
        if (questionList.endsWith(",")) {
            questionList = questionList.substring(0, questionList.length() - 1);
        }
        return questionList;
    }

    protected Boolean isBaseType(Class clazz) {
        return clazz == String.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == Object.class;
    }

    public <T> T hash2Class(HashMap map, Class<T> clazz) {
        if (null == clazz) {
            return null;
        }
        T u = null;
        try {
            u = clazz.newInstance();
            for (Object key : map.keySet()) {
                Field field = clazz.getDeclaredField(key.toString());
                field.setAccessible(true);
                Class<?> obj = field.getType();
                Object value = Boolean.class == obj ? Boolean.valueOf(map.get(key).equals("1")) : map.get(key);
                field.set(u, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return u;
    }

    public <T> HashMap class2Hash(Object entity) {
        if (null == entity) {
            return null;
        }
        Class<?> clazz = entity.getClass();
        Field[] field = clazz.getDeclaredFields();
        HashMap<String, Object> hashmap = new HashMap<String, Object>();
        try {
            for (Field f : field) {
                f.setAccessible(true);
                hashmap.put(f.getName(), f.get(entity));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hashmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Cache<String, Integer> getPageCache() {
        if (pageCache != null) {
            return pageCache;
        }
        Properties properties = new Properties();
        InputStream is = null;
        String location = "classpath:page.properties";
        try {
            Resource resource = new DefaultResourceLoader().getResource(location);
            is = resource.getInputStream();
            properties.load(is);
        }
        catch (IOException ex) {
            log.warn("Could not load properties from path:" + location);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        pageCache = CacheFactory.createCache(properties.getProperty("pageCacheClass"), "page.", properties);
        return pageCache;
    }
}

